/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.server.internal.storage.DirectoryBasedStorageManager;
import com.linecorp.centraldogma.server.internal.storage.project.DefaultProject;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class DefaultProjectManager
extends DirectoryBasedStorageManager<Project>
implements ProjectManager {
    private final Executor repositoryWorker;
    @Nullable
    private final RepositoryCache cache;

    public DefaultProjectManager(File rootDir, Executor repositoryWorker, Executor purgeWorker, MeterRegistry meterRegistry, @Nullable String cacheSpec) {
        super(rootDir, Project.class, purgeWorker);
        Objects.requireNonNull(meterRegistry, "meterRegistry");
        Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.repositoryWorker = repositoryWorker;
        this.cache = cacheSpec != null ? new RepositoryCache(cacheSpec, meterRegistry) : null;
        this.init();
    }

    @Override
    public void close(Supplier<CentralDogmaException> failureCauseSupplier) {
        super.close(failureCauseSupplier);
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    protected Project openChild(File childDir) throws Exception {
        return new DefaultProject(childDir, this.repositoryWorker, this.purgeWorker(), this.cache);
    }

    @Override
    protected Project createChild(File childDir, Author author, long creationTimeMillis) throws Exception {
        return new DefaultProject(childDir, this.repositoryWorker, this.purgeWorker(), creationTimeMillis, author, this.cache);
    }

    @Override
    protected void closeChild(File childDir, Project child, Supplier<CentralDogmaException> failureCauseSupplier) {
        DefaultProject c = (DefaultProject)child;
        c.repos.close(failureCauseSupplier);
    }

    @Override
    protected CentralDogmaException newStorageExistsException(String name) {
        return new ProjectExistsException(name);
    }

    @Override
    protected CentralDogmaException newStorageNotFoundException(String name) {
        return new ProjectNotFoundException(name);
    }
}

