/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.server.internal.storage.repository.MirrorConfig;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryMetadataException;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryWrapper;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorCredential;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

public final class DefaultMetaRepository
extends RepositoryWrapper
implements MetaRepository {
    public static final String PATH_CREDENTIALS = "/credentials.json";
    public static final String PATH_MIRRORS = "/mirrors.json";
    public static final Set<String> metaRepoFiles = ImmutableSet.of((Object)"/credentials.json", (Object)"/mirrors.json");
    private static final String PATH_CREDENTIALS_AND_MIRRORS = "/credentials.json,/mirrors.json";
    private final Lock mirrorLock = new ReentrantLock();
    private int mirrorRev = -1;
    private Set<String> mirrorRepos = Collections.emptySet();
    @Nullable
    private Set<Mirror> mirrors;

    public DefaultMetaRepository(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Mirror> mirrors() {
        this.mirrorLock.lock();
        try {
            int headRev = this.normalizeNow(Revision.HEAD).major();
            Set<String> repos = this.parent().repos().list().keySet();
            if (headRev > this.mirrorRev || !this.mirrorRepos.equals(repos)) {
                this.mirrors = this.loadMirrors(headRev);
                this.mirrorRev = headRev;
                this.mirrorRepos = repos;
            }
            Set<Mirror> set = this.mirrors;
            return set;
        }
        finally {
            this.mirrorLock.unlock();
        }
    }

    private Set<Mirror> loadMirrors(int rev) {
        Map<String, Entry<?>> entries = this.find(new Revision(rev), PATH_CREDENTIALS_AND_MIRRORS, Collections.emptyMap()).join();
        if (!entries.containsKey(PATH_MIRRORS)) {
            return Collections.emptySet();
        }
        JsonNode mirrorsJson = (JsonNode)entries.get(PATH_MIRRORS).content();
        if (!mirrorsJson.isArray()) {
            throw new RepositoryMetadataException("/mirrors.json must be an array: " + mirrorsJson.getNodeType());
        }
        if (mirrorsJson.size() == 0) {
            return Collections.emptySet();
        }
        try {
            List<MirrorCredential> credentials = DefaultMetaRepository.loadCredentials(entries);
            ImmutableSet.Builder mirrors = ImmutableSet.builder();
            for (JsonNode m : mirrorsJson) {
                MirrorConfig c = (MirrorConfig)Jackson.treeToValue((TreeNode)m, MirrorConfig.class);
                if (c == null) {
                    throw new RepositoryMetadataException("/mirrors.json contains null.");
                }
                Mirror mirror = c.toMirror(this.parent(), credentials);
                if (mirror == null) continue;
                mirrors.add((Object)mirror);
            }
            return mirrors.build();
        }
        catch (RepositoryMetadataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryMetadataException("failed to load the mirror configuration", e);
        }
    }

    private static List<MirrorCredential> loadCredentials(Map<String, Entry<?>> entries) throws Exception {
        Entry<?> e = entries.get(PATH_CREDENTIALS);
        if (e == null) {
            return Collections.emptyList();
        }
        JsonNode credentialsJson = (JsonNode)e.content();
        if (!credentialsJson.isArray()) {
            throw new RepositoryMetadataException("/credentials.json must be an array: " + credentialsJson.getNodeType());
        }
        if (credentialsJson.size() == 0) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JsonNode c : credentialsJson) {
            MirrorCredential credential = (MirrorCredential)Jackson.treeToValue((TreeNode)c, MirrorCredential.class);
            if (credential == null) {
                throw new RepositoryMetadataException("/credentials.json contains null.");
            }
            builder.add((Object)credential);
        }
        return builder.build();
    }
}

