/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.metadata.Identifiable;
import com.linecorp.centraldogma.server.metadata.Member;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.metadata.TokenRegistration;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectMetadata
implements Identifiable {
    private final String name;
    private final Map<String, RepositoryMetadata> repos;
    private final Map<String, Member> members;
    private final Map<String, TokenRegistration> tokens;
    private final UserAndTimestamp creation;
    @Nullable
    private final UserAndTimestamp removal;

    @JsonCreator
    public ProjectMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="repos") Map<String, RepositoryMetadata> repos, @JsonProperty(value="members") Map<String, Member> members, @JsonProperty(value="tokens") Map<String, TokenRegistration> tokens, @JsonProperty(value="creation") UserAndTimestamp creation, @JsonProperty(value="removal") @Nullable UserAndTimestamp removal) {
        this.name = Objects.requireNonNull(name, "name");
        this.repos = Objects.requireNonNull(repos, "repos");
        this.members = Objects.requireNonNull(members, "members");
        this.tokens = Objects.requireNonNull(tokens, "tokens");
        this.creation = Objects.requireNonNull(creation, "creation");
        this.removal = removal;
    }

    @Override
    public String id() {
        return this.name;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public Map<String, RepositoryMetadata> repos() {
        return this.repos;
    }

    @JsonProperty
    public Map<String, Member> members() {
        return this.members;
    }

    @JsonProperty
    public Map<String, TokenRegistration> tokens() {
        return this.tokens;
    }

    @JsonProperty
    public UserAndTimestamp creation() {
        return this.creation;
    }

    @Nullable
    @JsonProperty
    public UserAndTimestamp removal() {
        return this.removal;
    }

    public RepositoryMetadata repo(String repoName) {
        RepositoryMetadata repositoryMetadata = this.repos.get(Objects.requireNonNull(repoName, "repoName"));
        if (repositoryMetadata != null) {
            return repositoryMetadata;
        }
        throw new RepositoryNotFoundException(repoName);
    }

    public Member member(String memberId) {
        Member member = this.memberOrDefault(memberId, null);
        if (member != null) {
            return member;
        }
        throw new EntryNotFoundException(memberId);
    }

    @Nullable
    public Member memberOrDefault(String memberId, @Nullable Member defaultMember) {
        Member member = this.members.get(Objects.requireNonNull(memberId, "memberId"));
        if (member != null) {
            return member;
        }
        return defaultMember;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name()).add("repos", this.repos()).add("members", this.members()).add("tokens", this.tokens()).add("creation", (Object)this.creation()).add("removal", (Object)this.removal()).toString();
    }
}

