/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.project;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.Ascii;
import com.linecorp.centraldogma.server.storage.project.ProjectUtil;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryManager;
import java.util.List;
import java.util.Objects;

public interface Project {
    public static final String REPO_DOGMA = "dogma";
    public static final String REPO_META = "meta";

    public String name();

    default public long creationTimeMillis() {
        return ((Repository)this.repos().get(REPO_DOGMA)).creationTimeMillis();
    }

    default public Author author() {
        return ((Repository)this.repos().get(REPO_DOGMA)).author();
    }

    public MetaRepository metaRepo();

    public RepositoryManager repos();

    public static List<String> internalRepos() {
        return ProjectUtil.internalRepos;
    }

    public static boolean isReservedRepoName(String repoName) {
        Objects.requireNonNull(repoName, "repoName");
        repoName = Ascii.toLowerCase((String)repoName);
        return Project.internalRepos().contains(repoName);
    }
}

