/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.ConfigValueConverter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.List;

enum DefaultConfigValueConverter implements ConfigValueConverter
{
    INSTANCE;

    private static final String PLAINTEXT = "plaintext";
    private static final String FILE = "file";
    private static final String BASE64 = "base64";
    private static final List<String> SUPPORTED_PREFIXES;

    @Override
    public List<String> supportedPrefixes() {
        return SUPPORTED_PREFIXES;
    }

    @Override
    public String convert(String prefix, String value) {
        switch (prefix) {
            case "plaintext": {
                return value;
            }
            case "file": {
                try {
                    return new String(Files.readAllBytes(Paths.get(value, new String[0])), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException("failed to read a file: " + value, e);
                }
            }
            case "base64": {
                return new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8).trim();
            }
        }
        throw new Error();
    }

    static {
        SUPPORTED_PREFIXES = ImmutableList.of((Object)PLAINTEXT, (Object)FILE, (Object)BASE64);
    }
}

