/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.kotlinjdsl.render.jpql.serializer.impl;

import com.linecorp.kotlinjdsl.Internal;
import com.linecorp.kotlinjdsl.querymodel.jpql.expression.impl.JpqlLiteral;
import com.linecorp.kotlinjdsl.render.RenderContext;
import com.linecorp.kotlinjdsl.render.jpql.serializer.JpqlSerializer;
import com.linecorp.kotlinjdsl.render.jpql.writer.JpqlWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/linecorp/kotlinjdsl/render/jpql/serializer/impl/JpqlLiteralSerializer;", "Lcom/linecorp/kotlinjdsl/render/jpql/serializer/JpqlSerializer;", "Lcom/linecorp/kotlinjdsl/querymodel/jpql/expression/impl/JpqlLiteral;", "()V", "handledType", "Lkotlin/reflect/KClass;", "serialize", "", "part", "Lcom/linecorp/kotlinjdsl/querymodel/jpql/expression/impl/JpqlLiteral$BooleanLiteral;", "writer", "Lcom/linecorp/kotlinjdsl/render/jpql/writer/JpqlWriter;", "Lcom/linecorp/kotlinjdsl/querymodel/jpql/expression/impl/JpqlLiteral$CharLiteral;", "Lcom/linecorp/kotlinjdsl/querymodel/jpql/expression/impl/JpqlLiteral$DoubleLiteral;", "Lcom/linecorp/kotlinjdsl/querymodel/jpql/expression/impl/JpqlLiteral$EnumLiteral;", "Lcom/linecorp/kotlinjdsl/querymodel/jpql/expression/impl/JpqlLiteral$FloatLiteral;", "Lcom/linecorp/kotlinjdsl/querymodel/jpql/expression/impl/JpqlLiteral$IntLiteral;", "Lcom/linecorp/kotlinjdsl/querymodel/jpql/expression/impl/JpqlLiteral$LongLiteral;", "Lcom/linecorp/kotlinjdsl/querymodel/jpql/expression/impl/JpqlLiteral$StringLiteral;", "context", "Lcom/linecorp/kotlinjdsl/render/RenderContext;", "serializeNull", "jpql-render"})
@Internal
public final class JpqlLiteralSerializer
implements JpqlSerializer<JpqlLiteral<?>> {
    @Override
    @NotNull
    public KClass<JpqlLiteral<?>> handledType() {
        return Reflection.getOrCreateKotlinClass(JpqlLiteral.class);
    }

    @Override
    public void serialize(@NotNull JpqlLiteral<?> part, @NotNull JpqlWriter writer, @NotNull RenderContext context) {
        Intrinsics.checkNotNullParameter(part, (String)"part");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JpqlLiteral<?> jpqlLiteral = part;
        if (jpqlLiteral instanceof JpqlLiteral.IntLiteral) {
            this.serialize((JpqlLiteral.IntLiteral)part, writer);
        } else if (jpqlLiteral instanceof JpqlLiteral.LongLiteral) {
            this.serialize((JpqlLiteral.LongLiteral)part, writer);
        } else if (jpqlLiteral instanceof JpqlLiteral.FloatLiteral) {
            this.serialize((JpqlLiteral.FloatLiteral)part, writer);
        } else if (jpqlLiteral instanceof JpqlLiteral.DoubleLiteral) {
            this.serialize((JpqlLiteral.DoubleLiteral)part, writer);
        } else if (jpqlLiteral instanceof JpqlLiteral.BooleanLiteral) {
            this.serialize((JpqlLiteral.BooleanLiteral)part, writer);
        } else if (jpqlLiteral instanceof JpqlLiteral.CharLiteral) {
            this.serialize((JpqlLiteral.CharLiteral)part, writer);
        } else if (jpqlLiteral instanceof JpqlLiteral.StringLiteral) {
            this.serialize((JpqlLiteral.StringLiteral)part, writer);
        } else if (jpqlLiteral instanceof JpqlLiteral.EnumLiteral) {
            this.serialize((JpqlLiteral.EnumLiteral)part, writer);
        } else if (jpqlLiteral instanceof JpqlLiteral.NullLiteral) {
            this.serializeNull(writer);
        }
    }

    private final void serialize(JpqlLiteral.IntLiteral part, JpqlWriter writer) {
        writer.write(String.valueOf(part.getInt()));
    }

    private final void serialize(JpqlLiteral.LongLiteral part, JpqlWriter writer) {
        writer.write(String.valueOf(part.getLong()));
        writer.write("L");
    }

    private final void serialize(JpqlLiteral.FloatLiteral part, JpqlWriter writer) {
        writer.write(String.valueOf(part.getFloat()));
        writer.write("F");
    }

    private final void serialize(JpqlLiteral.DoubleLiteral part, JpqlWriter writer) {
        writer.write(String.valueOf(part.getDouble()));
    }

    private final void serialize(JpqlLiteral.BooleanLiteral part, JpqlWriter writer) {
        if (part.getBoolean()) {
            writer.write("TRUE");
        } else {
            writer.write("FALSE");
        }
    }

    private final void serialize(JpqlLiteral.CharLiteral part, JpqlWriter writer) {
        writer.write("'");
        if (part.getChar() == '\'') {
            writer.write("''");
        } else {
            writer.write(String.valueOf(part.getChar()));
        }
        writer.write("'");
    }

    private final void serialize(JpqlLiteral.StringLiteral part, JpqlWriter writer) {
        String encodedString = StringsKt.replace$default((String)part.getString(), (String)"'", (String)"''", (boolean)false, (int)4, null);
        writer.write("'");
        writer.write(encodedString);
        writer.write("'");
    }

    private final void serialize(JpqlLiteral.EnumLiteral<?> part, JpqlWriter writer) {
        writer.write(part.getEnum().getClass().getName() + '.' + part.getEnum().name());
    }

    private final void serializeNull(JpqlWriter writer) {
        writer.write("NULL");
    }
}

