/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans;

import com.link_intersystems.beans.BeanClass;
import com.link_intersystems.beans.BeanEvent;
import com.link_intersystems.beans.BeanEventType;
import com.link_intersystems.beans.BeanEventTypeList;
import com.link_intersystems.beans.IndexedProperty;
import com.link_intersystems.beans.PropertyList;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class Bean<T> {
    private BeanClass<T> beanClass;
    private T bean;
    private PropertyList properties;
    private PropertyList indexedProperties;

    protected Bean(BeanClass<T> beanClass, T bean) {
        this.beanClass = Objects.requireNonNull(beanClass);
        this.bean = Objects.requireNonNull(bean);
    }

    public BeanClass<T> getBeanClass() {
        return this.beanClass;
    }

    public T getBeanObject() {
        return this.bean;
    }

    public abstract PropertyList getAllProperties();

    public PropertyList getProperties() {
        if (this.properties == null) {
            this.properties = new PropertyList(this.getAllProperties().stream().filter(p -> !(p instanceof IndexedProperty)).collect(Collectors.toList()));
        }
        return this.properties;
    }

    public PropertyList getIndexedProperties() {
        if (this.indexedProperties == null) {
            this.indexedProperties = new PropertyList(this.getAllProperties().stream().filter(p -> p instanceof IndexedProperty).collect(Collectors.toList()));
        }
        return this.indexedProperties;
    }

    public void removeListener(Object listener) {
        if (listener == null) {
            return;
        }
        BeanEvent applicableBeanEvent = this.getApplicableBeanEvent(listener);
        if (applicableBeanEvent == null) {
            String msg = MessageFormat.format("{0} can not handle listener {1}", this.getBeanClass(), listener.getClass());
            throw new UnsupportedOperationException(msg);
        }
        applicableBeanEvent.removeListener(listener);
    }

    public void addListener(Object listener) {
        if (listener == null) {
            return;
        }
        BeanEvent applicableBeanEvent = this.getApplicableBeanEvent(listener);
        if (applicableBeanEvent == null) {
            String msg = MessageFormat.format("{0} can not handle listener {1}", this.getBeanClass(), listener.getClass());
            throw new UnsupportedOperationException(msg);
        }
        applicableBeanEvent.addListener(listener);
    }

    protected BeanEvent getApplicableBeanEvent(Object listener) {
        BeanClass<T> beanClass = this.getBeanClass();
        BeanEventTypeList beanEventTypes = beanClass.getBeanEventTypes();
        BeanEvent applicableBeanEvent = null;
        for (BeanEventType beanEventType : beanEventTypes) {
            if (!beanEventType.isApplicable(listener)) continue;
            T beanObject = this.getBeanObject();
            applicableBeanEvent = beanEventType.newBeanEvent(beanObject);
            break;
        }
        return applicableBeanEvent;
    }

    public boolean propertiesEqual(Bean<T> otherBean) {
        PropertyList properties = this.getProperties();
        PropertyList otherProperties = otherBean.getProperties();
        return properties.equals(otherProperties);
    }
}

