/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans;

import com.link_intersystems.beans.ArgumentResolver;
import com.link_intersystems.beans.Bean;
import com.link_intersystems.beans.BeanEventTypeList;
import com.link_intersystems.beans.BeanInstanceFactory;
import com.link_intersystems.beans.BeanInstantiationException;
import com.link_intersystems.beans.FilteredBeanClass;
import com.link_intersystems.beans.IndexedPropertyDesc;
import com.link_intersystems.beans.PropertyDesc;
import com.link_intersystems.beans.PropertyDescFilter;
import com.link_intersystems.beans.PropertyDescList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class BeanClass<T> {
    protected static final Predicate<? super PropertyDesc> INDEXED_PROPERTY_FILTER = jpd -> jpd instanceof IndexedPropertyDesc;
    protected static final Predicate<? super PropertyDesc> NO_INDEXED_PROPERTY_FILTER = jpd -> !INDEXED_PROPERTY_FILTER.test((PropertyDesc)jpd);
    private transient PropertyDescList properties;
    private transient PropertyDescList indexedProperties;

    public abstract String getName();

    public abstract Class<T> getType();

    public boolean isInstance(Object bean) {
        return this.getType().isInstance(bean);
    }

    public Bean<T> newBeanInstance() throws BeanInstantiationException {
        BeanInstanceFactory<T> beanInstanceFactory = this.getBeanInstanceFactory();
        return beanInstanceFactory.newBeanInstance();
    }

    public BeanInstanceFactory<T> getBeanInstanceFactory() {
        return this.getBeanInstanceFactory(ad -> null);
    }

    public abstract BeanInstanceFactory<T> getBeanInstanceFactory(ArgumentResolver var1);

    public Bean<T> getBeanFromInstance(T beanObject) {
        BeanInstanceFactory<T> beanInstanceFactory = this.getBeanInstanceFactory();
        return beanInstanceFactory.fromExistingInstance(beanObject);
    }

    public PropertyDescList getProperties() {
        if (this.properties == null) {
            List propertyDescs = this.getAllProperties().stream().filter(NO_INDEXED_PROPERTY_FILTER).collect(Collectors.toList());
            this.properties = new PropertyDescList(propertyDescs);
        }
        return this.properties;
    }

    public PropertyDescList getIndexedProperties() {
        if (this.indexedProperties == null) {
            List propertyDescs = this.getAllProperties().stream().filter(INDEXED_PROPERTY_FILTER).collect(Collectors.toList());
            this.indexedProperties = new PropertyDescList(propertyDescs);
        }
        return this.indexedProperties;
    }

    public abstract PropertyDescList getAllProperties();

    public boolean hasAnyProperty(String propertyName) {
        return this.hasProperty(propertyName) || this.hasIndexedProperty(propertyName);
    }

    boolean hasProperty(String propertyName) {
        return this.getProperties().stream().map(PropertyDesc::getName).anyMatch(propertyName::equals);
    }

    boolean hasIndexedProperty(String propertyName) {
        return this.getIndexedProperties().stream().map(PropertyDesc::getName).anyMatch(propertyName::equals);
    }

    public BeanEventTypeList getBeanEventTypes() {
        return BeanEventTypeList.EMPTY;
    }

    public boolean isListenerSupported(Class<?> listenerClass) {
        return this.getBeanEventTypes().stream().anyMatch(be -> be.isApplicable(listenerClass));
    }

    public BeanClass<T> filter(PropertyDescFilter propertyDescFilter) {
        return new FilteredBeanClass(this, propertyDescFilter);
    }
}

