/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans;

import com.link_intersystems.beans.Bean;
import java.util.Optional;

public class BeanEventSupport<T, L> {
    private Optional<L> listener = Optional.empty();
    private Optional<Bean<? extends T>> bean = Optional.empty();
    private boolean eventEnabled = true;

    public boolean isEventEnabled() {
        return this.eventEnabled;
    }

    public BeanEventSupport() {
    }

    public BeanEventSupport(Bean<? extends T> bean) {
        this.setBean(bean);
    }

    public void setEventEnabled(boolean enabled) {
        if (enabled) {
            this.bean.ifPresent(b -> this.listener.ifPresent(b::addListener));
        } else {
            this.bean.ifPresent(b -> this.listener.ifPresent(b::removeListener));
        }
        this.eventEnabled = enabled;
    }

    public L getListener() {
        return this.listener.orElse(null);
    }

    public void setListener(L newListener) {
        this.bean.ifPresent(b -> this.listener.ifPresent(b::removeListener));
        this.listener = Optional.ofNullable(newListener);
        if (this.eventEnabled) {
            this.bean.ifPresent(b -> this.listener.ifPresent(b::addListener));
        }
    }

    public T getBean() {
        return this.bean.map(Bean::getBeanObject).orElse(null);
    }

    public void setBean(Bean<? extends T> newBean) {
        if (this.bean.orElse(null) == newBean) {
            return;
        }
        this.bean.ifPresent(b -> this.listener.ifPresent(b::removeListener));
        this.bean = Optional.ofNullable(newBean);
        if (this.eventEnabled) {
            this.bean.ifPresent(b -> this.listener.ifPresent(b::addListener));
        }
    }
}

