/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans;

import com.link_intersystems.beans.BeanEventType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BeanEventTypeList
extends AbstractList<BeanEventType> {
    public static final BeanEventTypeList EMPTY = new BeanEventTypeList(Collections.emptyList());
    private List<BeanEventType> beanEventTypes = new ArrayList<BeanEventType>();
    private Map<String, BeanEventType> byName;

    public BeanEventTypeList(List<? extends BeanEventType> beanEventTypes) {
        this.beanEventTypes.addAll(beanEventTypes);
    }

    public BeanEventType getByName(String eventName) {
        if (this.byName == null) {
            this.byName = this.stream().collect(Collectors.toMap(BeanEventType::getName, Function.identity()));
        }
        return this.byName.get(eventName);
    }

    @Override
    public BeanEventType get(int index) {
        return this.beanEventTypes.get(index);
    }

    @Override
    public int size() {
        return this.beanEventTypes.size();
    }
}

