/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans;

import com.link_intersystems.beans.Bean;
import com.link_intersystems.beans.BeanClass;
import com.link_intersystems.beans.IndexedProperty;
import com.link_intersystems.beans.IndexedPropertyDesc;
import com.link_intersystems.beans.NoSuchPropertyException;
import com.link_intersystems.beans.Property;
import com.link_intersystems.beans.PropertyDesc;
import com.link_intersystems.beans.PropertyDescList;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BeanMapDecorator
extends AbstractMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = -6218854323681382593L;
    private Bean<?> bean;

    public BeanMapDecorator(Bean<?> bean) {
        this.bean = Objects.requireNonNull(bean);
    }

    public static Object indexSetter(int index, Object value) {
        return new IndexSetter(index, value);
    }

    private PropertyDescList getAllProperties() {
        BeanClass<?> beanClass = this.bean.getBeanClass();
        return beanClass.getAllProperties();
    }

    @Override
    public int size() {
        return this.getAllProperties().size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        String propertyName = key.toString();
        BeanClass<?> beanClass = this.bean.getBeanClass();
        return beanClass.hasAnyProperty(propertyName);
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        String propertyName = key.toString();
        PropertyDescList properties = this.getAllProperties();
        PropertyDesc propertyDesc = properties.getByName(propertyName);
        return this.get(propertyDesc);
    }

    private Object get(PropertyDesc propertyDesc) {
        String propertyName;
        if (propertyDesc == null) {
            return null;
        }
        BeanClass<?> beanClass = this.bean.getBeanClass();
        boolean isIndexedProperty = beanClass.hasIndexedProperty(propertyName = propertyDesc.getName());
        if (isIndexedProperty) {
            IndexedProperty property = (IndexedProperty)this.bean.getIndexedProperties().getByDesc(propertyDesc);
            this.checkReadAccess(property);
            return new IndexedValue(property);
        }
        Property property = this.bean.getProperties().getByDesc(propertyDesc);
        this.checkReadAccess(property);
        return property.getValue();
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("BeanMapDecorator does not support putting 'null' keys, because a bean can never have a 'null' property.");
        }
        BeanClass<?> beanClass = this.bean.getBeanClass();
        PropertyDescList properties = beanClass.getAllProperties();
        PropertyDesc propertyDesc = properties.getByName(key);
        if (propertyDesc == null) {
            throw new NoSuchPropertyException(this.bean.getBeanClass().getType(), key);
        }
        return this.put(propertyDesc, value);
    }

    @Override
    private Object put(PropertyDesc propertyDesc, Object value) {
        Object previousValue = null;
        if (propertyDesc instanceof IndexedPropertyDesc) {
            if (!(value instanceof IndexSetter)) {
                throw new IllegalArgumentException("Property named " + propertyDesc.getName() + " is an indexed property. To set an indexed property's value you must use " + IndexSetter.class.getSimpleName() + " to wrap the value.");
            }
            IndexSetter indexedValueSet = (IndexSetter)IndexSetter.class.cast(value);
            IndexedProperty indexedProperty = (IndexedProperty)this.bean.getIndexedProperties().getByDesc(propertyDesc);
            this.checkWriteAccess(indexedProperty);
            Object element = indexedValueSet.getElement();
            indexedProperty.setValue(indexedValueSet.getIndex(), element);
        } else {
            Property property = this.bean.getProperties().getByDesc(propertyDesc);
            this.checkWriteAccess(property);
            previousValue = this.getValueIfReadable(propertyDesc.getName());
            property.setValue(value);
        }
        return previousValue;
    }

    private Object getValueIfReadable(String propertyName) {
        Property property = this.bean.getAllProperties().getByName(propertyName);
        if (property.getPropertyDesc().isReadable()) {
            return property.getValue();
        }
        return null;
    }

    private void checkWriteAccess(IndexedProperty property) {
        if (!property.getPropertyDesc().isIndexedWritable()) {
            throw new UnsupportedOperationException("BeanMapDecorator can not put property " + property + ", because the indexed property has no indexed setter method, e.g. void setter(int index, PropertyType value); ");
        }
    }

    private void checkWriteAccess(Property property) {
        if (!property.getPropertyDesc().isWritable()) {
            throw new UnsupportedOperationException("BeanMapDecorator can not put property " + property + ", because the property is not writable");
        }
    }

    private void checkReadAccess(IndexedProperty property) {
        if (!property.getPropertyDesc().isIndexedReadable()) {
            throw new UnsupportedOperationException("BeanMapDecorator can not get property " + property + ", because the indexed property has no indexed getter method, e.g. PropertyType getter(int index);");
        }
    }

    private void checkReadAccess(Property property) {
        if (!property.getPropertyDesc().isReadable()) {
            throw new UnsupportedOperationException("BeanMapDecorator can not get property " + property + ", because the property is not readable");
        }
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("BeanMapDecorator does not support remove");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("A BeanMapDecorator can not be cleared, because properties of a bean belong to the bean's class and therefore can not be removed at runtime.");
    }

    @Override
    public Set<String> keySet() {
        BeanClass<?> beanClass = this.bean.getBeanClass();
        PropertyDescList allProperties = beanClass.getAllProperties();
        return new LinkedHashSet<String>(allProperties.getPropertyNames());
    }

    @Override
    public Collection<Object> values() {
        AbstractCollection<Object> values = new AbstractCollection<Object>(){

            @Override
            public Iterator<Object> iterator() {
                final Iterator readablePropertyDescs = BeanMapDecorator.this.bean.getBeanClass().getAllProperties().stream().filter(PropertyDesc::isReadable).iterator();
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return readablePropertyDescs.hasNext();
                    }

                    @Override
                    public Object next() {
                        PropertyDesc propertyDesc = (PropertyDesc)readablePropertyDescs.next();
                        if (propertyDesc instanceof IndexedPropertyDesc) {
                            IndexedProperty indexedProperty = (IndexedProperty)BeanMapDecorator.this.bean.getIndexedProperties().getByDesc(propertyDesc);
                            return new IndexedValue(indexedProperty);
                        }
                        return propertyDesc.getPropertyValue(BeanMapDecorator.this.bean.getBeanObject());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Bean properties can not be removed.");
                    }
                };
            }

            @Override
            public int size() {
                return BeanMapDecorator.this.bean.getBeanClass().getAllProperties().getPropertyNames().size();
            }
        };
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        AbstractSet<Map.Entry<String, Object>> entries = new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                final Iterator propertyDescIterator = BeanMapDecorator.this.bean.getBeanClass().getAllProperties().iterator();
                return new Iterator<Map.Entry<String, Object>>(){

                    @Override
                    public boolean hasNext() {
                        return propertyDescIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        final PropertyDesc propertyDesc = (PropertyDesc)propertyDescIterator.next();
                        return new Map.Entry<String, Object>(){

                            @Override
                            public Object setValue(Object value) {
                                return BeanMapDecorator.this.put(propertyDesc, value);
                            }

                            @Override
                            public Object getValue() {
                                return BeanMapDecorator.this.get(propertyDesc);
                            }

                            @Override
                            public String getKey() {
                                return propertyDesc.getName();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return BeanMapDecorator.this.size();
            }
        };
        return entries;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public static final class IndexSetter {
        private final int index;
        private final Object element;

        private IndexSetter(int index, Object element) {
            this.index = index;
            this.element = element;
        }

        public int getIndex() {
            return this.index;
        }

        public Object getElement() {
            return this.element;
        }
    }

    public static final class IndexedValue {
        private final IndexedProperty indexedProperty;

        private IndexedValue(IndexedProperty indexedProperty) {
            this.indexedProperty = indexedProperty;
        }

        public Object getElement(int index) {
            return this.indexedProperty.getValue(index);
        }
    }
}

