/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans;

import com.link_intersystems.beans.Bean;
import com.link_intersystems.beans.BeanClass;
import com.link_intersystems.beans.BeanClassException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class BeansFactory {
    private static BeansFactory DEFAULT_BEANS_FACTORY;

    public static BeansFactory getDefault() {
        if (DEFAULT_BEANS_FACTORY == null) {
            DEFAULT_BEANS_FACTORY = BeansFactory.getInstance("java");
        }
        return DEFAULT_BEANS_FACTORY;
    }

    public static BeansFactory getInstance(String type) {
        ServiceLoader<BeansFactory> loader = ServiceLoader.load(BeansFactory.class);
        Stream<BeansFactory> beansFactoryStream = StreamSupport.stream(loader.spliterator(), false);
        List beansFactories = beansFactoryStream.filter(bf -> bf.getTypeName().equals(type)).collect(Collectors.toList());
        if (beansFactories.isEmpty()) {
            throw new IllegalArgumentException("No BeansFactory of type " + type + " found.");
        }
        if (beansFactories.size() > 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("BeansFactory type ''");
            msg.append(type);
            msg.append("'' is ambiguous. ");
            msg.append(beansFactories.size());
            msg.append(" BeansFactories found:\n");
            for (BeansFactory beansFactory : beansFactories) {
                msg.append("\to ");
                msg.append(beansFactory.getClass().getName());
            }
            throw new IllegalStateException(msg.toString());
        }
        return (BeansFactory)beansFactories.get(0);
    }

    public abstract String getTypeName();

    public <T> BeanClass<T> createBeanClass(Class<T> beanClass) throws BeanClassException {
        return this.createBeanClass(beanClass, null);
    }

    public abstract <T> BeanClass<T> createBeanClass(Class<T> var1, Class<?> var2) throws BeanClassException;

    public <T> Bean<T> createBean(T bean) throws BeanClassException {
        return this.createBean(bean, null);
    }

    public <T> Bean<T> createBean(T bean, Class<?> stopClass) throws BeanClassException {
        BeanClass<?> beanClass = this.createBeanClass(bean.getClass(), stopClass);
        return beanClass.getBeanFromInstance(bean);
    }
}

