/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans;

import com.link_intersystems.beans.ArgumentResolver;
import com.link_intersystems.beans.Bean;
import com.link_intersystems.beans.BeanClass;
import com.link_intersystems.beans.BeanEventTypeList;
import com.link_intersystems.beans.BeanInstanceFactory;
import com.link_intersystems.beans.Property;
import com.link_intersystems.beans.PropertyDescFilter;
import com.link_intersystems.beans.PropertyDescList;
import com.link_intersystems.beans.PropertyList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class FilteredBeanClass<T>
extends BeanClass<T> {
    private BeanClass<T> beanClass;
    private PropertyDescFilter propertyFilter;

    FilteredBeanClass(BeanClass<T> beanClass, PropertyDescFilter propertyFilter) {
        this.beanClass = Objects.requireNonNull(beanClass);
        this.propertyFilter = Objects.requireNonNull(propertyFilter);
    }

    @Override
    public String getName() {
        return this.beanClass.getName();
    }

    @Override
    public Class<T> getType() {
        return this.beanClass.getType();
    }

    @Override
    public BeanInstanceFactory<T> getBeanInstanceFactory(ArgumentResolver argumentResolver) {
        final BeanInstanceFactory<T> beanInstanceFactory = this.beanClass.getBeanInstanceFactory(argumentResolver);
        return new BeanInstanceFactory<T>(){

            @Override
            public Bean<T> newBeanInstance() {
                Bean bean = beanInstanceFactory.newBeanInstance();
                return new FilteredBean(FilteredBeanClass.this, bean, FilteredBeanClass.this.propertyFilter);
            }

            @Override
            public Bean<T> fromExistingInstance(T beanObject) {
                Bean bean = beanInstanceFactory.fromExistingInstance(beanObject);
                return new FilteredBean(FilteredBeanClass.this, bean, FilteredBeanClass.this.propertyFilter);
            }
        };
    }

    @Override
    public BeanEventTypeList getBeanEventTypes() {
        return this.beanClass.getBeanEventTypes();
    }

    @Override
    public PropertyDescList getProperties() {
        PropertyDescList properties = this.beanClass.getProperties();
        return this.getFilteredProperties(properties);
    }

    @Override
    public PropertyDescList getIndexedProperties() {
        PropertyDescList properties = this.beanClass.getIndexedProperties();
        return this.getFilteredProperties(properties);
    }

    @Override
    public PropertyDescList getAllProperties() {
        PropertyDescList properties = this.beanClass.getAllProperties();
        return this.getFilteredProperties(properties);
    }

    private PropertyDescList getFilteredProperties(PropertyDescList properties) {
        List filteredPropertyDescs = properties.stream().filter(this.propertyFilter::accept).collect(Collectors.toList());
        return new PropertyDescList(filteredPropertyDescs);
    }

    public String toString() {
        return "FilteredBeanClass{beanClass=" + this.beanClass + ", propertyFilter=" + this.propertyFilter + '}';
    }

    private static class FilteredBean<T>
    extends Bean<T> {
        private final BeanClass<T> beanClass;
        private final Bean<T> bean;
        private final PropertyDescFilter propertyFilter;

        public FilteredBean(BeanClass<T> beanClass, Bean<T> bean, PropertyDescFilter propertyFilter) {
            super(beanClass, bean.getBeanObject());
            this.beanClass = beanClass;
            this.bean = bean;
            this.propertyFilter = propertyFilter;
        }

        @Override
        public PropertyList getAllProperties() {
            List properties = this.bean.getProperties().stream().filter(this::accept).collect(Collectors.toList());
            return new PropertyList(properties);
        }

        private boolean accept(Property property) {
            return this.propertyFilter.accept(property.getPropertyDesc());
        }

        @Override
        public T getBeanObject() {
            return this.bean.getBeanObject();
        }

        @Override
        public BeanClass<T> getBeanClass() {
            return this.beanClass;
        }

        @Override
        public void removeListener(Object listener) {
            this.bean.removeListener(listener);
        }

        @Override
        public void addListener(Object listener) {
            this.bean.addListener(listener);
        }

        public String toString() {
            return "FilteredBean{bean=" + this.bean + ", propertyFilter=" + this.propertyFilter + '}';
        }
    }
}

