/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans;

import com.link_intersystems.beans.PropertyDesc;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class PropertyDescList
extends AbstractList<PropertyDesc> {
    private List<PropertyDesc> descriptors = new ArrayList<PropertyDesc>();

    public PropertyDescList(List<? extends PropertyDesc> descriptors) {
        this.descriptors.addAll(descriptors);
    }

    public List<String> getPropertyNames() {
        return this.stream().map(PropertyDesc::getName).collect(Collectors.toList());
    }

    public PropertyDesc getByName(String propertyName) {
        return this.getByName(propertyName, Objects::equals);
    }

    public PropertyDesc getByName(String propertyName, BiFunction<String, String, Boolean> nameEquality) {
        return this.stream().filter(pd -> (Boolean)nameEquality.apply(propertyName, pd.getName())).findFirst().orElse(null);
    }

    @Override
    public PropertyDesc get(int index) {
        return this.descriptors.get(index);
    }

    @Override
    public int size() {
        return this.descriptors.size();
    }
}

