/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans;

import com.link_intersystems.beans.Property;
import com.link_intersystems.beans.PropertyDesc;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PropertyList
extends AbstractList<Property> {
    private List<? extends Property> properties;
    private Map<String, Property> propertyMap = new HashMap<String, Property>();
    private Map<PropertyDesc, Property> propertyByDesc = new HashMap<PropertyDesc, Property>();

    public PropertyList(List<? extends Property> properties) {
        this.properties = Objects.requireNonNull(properties);
        properties.forEach(property -> {
            String name = property.getPropertyDesc().getName();
            this.propertyMap.put(name, (Property)property);
            this.propertyByDesc.put(property.getPropertyDesc(), (Property)property);
        });
    }

    public Property getByName(String propertyName) {
        return this.propertyMap.get(propertyName);
    }

    public Property getByDesc(PropertyDesc propertyDesc) {
        return this.propertyByDesc.get(propertyDesc);
    }

    @Override
    public Property get(int index) {
        return this.properties.get(index);
    }

    @Override
    public int size() {
        return this.properties.size();
    }
}

