/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import com.link_intersystems.beans.java.SharedPropertyEditor;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSharedPropertyEditor
implements SharedPropertyEditor {
    protected PropertyChangeEventAdapter propertyChangeEventAdapter = new PropertyChangeEventAdapter();
    protected PropertyEditor propertyEditor;

    public AbstractSharedPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        propertyEditor.addPropertyChangeListener(this.propertyChangeEventAdapter);
    }

    @Override
    public Object getValue() {
        return this.getPropertyEditor().getValue();
    }

    @Override
    public void setValue(Object value) {
        this.getPropertyEditor().setValue(value);
    }

    @Override
    public boolean isPaintable() {
        return this.getPropertyEditor().isPaintable();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        this.getPropertyEditor().paintValue(gfx, box);
    }

    @Override
    public String getJavaInitializationString() {
        return this.getPropertyEditor().getJavaInitializationString();
    }

    @Override
    public String getAsText() {
        return this.getPropertyEditor().getAsText();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.getPropertyEditor().setAsText(text);
    }

    @Override
    public String[] getTags() {
        return this.getPropertyEditor().getTags();
    }

    @Override
    public Component getCustomEditor() {
        return this.getPropertyEditor().getCustomEditor();
    }

    @Override
    public boolean supportsCustomEditor() {
        return this.getPropertyEditor().supportsCustomEditor();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeEventAdapter.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeEventAdapter.removePropertyChangeListener(listener);
    }

    private PropertyEditor getPropertyEditor() {
        if (this.propertyEditor == null) {
            throw new IllegalStateException("SharedPropertyEditor has been released.");
        }
        return this.propertyEditor;
    }

    @Override
    public void release() {
        this.propertyChangeEventAdapter.release();
        this.propertyEditor = null;
    }

    protected void releaseListeners() {
        this.propertyChangeEventAdapter.releaseListeners();
    }

    class PropertyChangeEventAdapter
    implements PropertyChangeListener {
        private List<PropertyChangeListener> propetyChangeListeners = new ArrayList<PropertyChangeListener>();

        PropertyChangeEventAdapter() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(AbstractSharedPropertyEditor.this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            propertyChangeEvent.setPropagationId(evt.getPropagationId());
            this.propetyChangeListeners.forEach(l -> l.propertyChange(propertyChangeEvent));
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propetyChangeListeners.add(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propetyChangeListeners.remove(listener);
        }

        public void release() {
            AbstractSharedPropertyEditor.this.propertyEditor.removePropertyChangeListener(this);
        }

        public void releaseListeners() {
            this.propetyChangeListeners.clear();
        }
    }
}

