/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BeanInfoBeanMap
extends AbstractMap<String, Object> {
    private final BeanInfo beanInfo;
    private final Object bean;
    private Map<String, Object> beanProperties;

    public BeanInfoBeanMap(Object bean) throws IntrospectionException {
        this(bean, Object.class);
    }

    public BeanInfoBeanMap(Object bean, Class<?> stopClass) throws IntrospectionException {
        this(BeanInfoBeanMap.getBeanInfo(bean, stopClass), bean);
    }

    private static BeanInfo getBeanInfo(Object bean, Class<?> stopClass) throws IntrospectionException {
        Class<?> aClass = bean.getClass();
        return Introspector.getBeanInfo(aClass, stopClass);
    }

    public BeanInfoBeanMap(BeanInfo beanInfo, Object bean) {
        this.beanInfo = Objects.requireNonNull(beanInfo);
        this.bean = Objects.requireNonNull(bean);
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        Class<?> beanClass = beanDescriptor.getBeanClass();
        if (!beanClass.isInstance(bean)) {
            String msg = MessageFormat.format("BeanInfo ''{0}'' is not applicable to bean ''{1}''", beanInfo, bean);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.beanProperties == null) {
            this.beanProperties = this.getBeanProperties();
        }
        return this.beanProperties.entrySet();
    }

    private Map<String, Object> getBeanProperties() {
        PropertyDescriptor[] propertyDescriptors;
        LinkedHashMap<String, Object> beanProperties = new LinkedHashMap<String, Object>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = this.beanInfo.getPropertyDescriptors()) {
            try {
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null) continue;
                Object value = readMethod.invoke(this.bean, new Object[0]);
                beanProperties.put(propertyDescriptor.getName(), value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return beanProperties;
    }
}

