/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InterfaceBeanInfo
extends SimpleBeanInfo {
    private final List<Class<?>> filterInterfaces;
    private final BeanInfo mainBeanInfo;
    private BeanInfo[] additionalBeanInfo;

    public <T, B extends T> InterfaceBeanInfo(Class<T> beanInterface, Class<?> ... filterInterfaces) throws IntrospectionException {
        this.mainBeanInfo = Introspector.getBeanInfo(beanInterface);
        this.filterInterfaces = Arrays.asList(filterInterfaces);
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.mainBeanInfo.getBeanDescriptor();
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.mainBeanInfo.getEventSetDescriptors();
    }

    @Override
    public int getDefaultEventIndex() {
        return this.mainBeanInfo.getDefaultEventIndex();
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.mainBeanInfo.getPropertyDescriptors();
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.mainBeanInfo.getDefaultPropertyIndex();
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.mainBeanInfo.getMethodDescriptors();
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        if (this.additionalBeanInfo == null) {
            this.additionalBeanInfo = this.doGetAdditionalBeanInfo();
        }
        return this.additionalBeanInfo;
    }

    private BeanInfo[] doGetAdditionalBeanInfo() {
        BeanDescriptor beanDescriptor = this.mainBeanInfo.getBeanDescriptor();
        Class<?> mainBeanClass = beanDescriptor.getBeanClass();
        List<BeanInfo> interfacesAdditionalBeanInfo = this.getInterfacesAdditionalBeanInfo(mainBeanClass);
        return interfacesAdditionalBeanInfo.toArray(new BeanInfo[0]);
    }

    private List<BeanInfo> getInterfacesAdditionalBeanInfo(Class<?> beanClass) {
        Class<?>[] interfaces;
        ArrayList<BeanInfo> additionalBeanInfo = new ArrayList<BeanInfo>();
        for (Class<?> anInterface : interfaces = beanClass.getInterfaces()) {
            if (this.filterInterfaces.contains(anInterface)) continue;
            List<BeanInfo> superInterfaceBeanInfo = this.getAdditionalBeanInfo(anInterface);
            additionalBeanInfo.addAll(superInterfaceBeanInfo);
        }
        return additionalBeanInfo;
    }

    private List<BeanInfo> getAdditionalBeanInfo(Class<?> beanClass) {
        ArrayList<BeanInfo> additionalBeanInfo = new ArrayList<BeanInfo>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            additionalBeanInfo.add(beanInfo);
            List<BeanInfo> interfacesAdditionalBeanInfo = this.getInterfacesAdditionalBeanInfo(beanClass);
            additionalBeanInfo.addAll(interfacesAdditionalBeanInfo);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        return additionalBeanInfo;
    }

    @Override
    public Image getIcon(int iconKind) {
        return this.mainBeanInfo.getIcon(iconKind);
    }
}

