/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import com.link_intersystems.beans.Bean;
import com.link_intersystems.beans.PropertyList;
import com.link_intersystems.beans.java.JavaBeanClass;
import com.link_intersystems.beans.java.JavaIndexedProperty;
import com.link_intersystems.beans.java.JavaIndexedPropertyDesc;
import com.link_intersystems.beans.java.JavaProperty;
import com.link_intersystems.beans.java.JavaPropertyDesc;
import java.util.List;
import java.util.stream.Collectors;

public class JavaBean<T>
extends Bean<T> {
    private PropertyList propertyList;
    private List<JavaProperty> javaProperties;

    JavaBean(JavaBeanClass<T> beanClass, T bean) {
        super(beanClass, bean);
    }

    @Override
    public JavaBeanClass<T> getBeanClass() {
        return (JavaBeanClass)super.getBeanClass();
    }

    @Override
    public PropertyList getAllProperties() {
        if (this.propertyList == null) {
            this.propertyList = new PropertyList(this.getJavaProperties());
        }
        return this.propertyList;
    }

    List<JavaProperty> getJavaProperties() {
        if (this.javaProperties == null) {
            this.javaProperties = ((JavaBeanClass)this.getBeanClass()).getJavaPropertyDescs().stream().map(this::toProperty).collect(Collectors.toList());
        }
        return this.javaProperties;
    }

    private JavaProperty toProperty(JavaPropertyDesc propertyDesc) {
        if (propertyDesc instanceof JavaIndexedPropertyDesc) {
            return new JavaIndexedProperty(this, (JavaIndexedPropertyDesc)propertyDesc);
        }
        return new JavaProperty(this, propertyDesc);
    }
}

