/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import com.link_intersystems.beans.ArgumentResolver;
import com.link_intersystems.beans.BeanClass;
import com.link_intersystems.beans.BeanClassException;
import com.link_intersystems.beans.BeanEventTypeList;
import com.link_intersystems.beans.BeanInstanceFactory;
import com.link_intersystems.beans.PropertyDescList;
import com.link_intersystems.beans.java.JavaBeanEventType;
import com.link_intersystems.beans.java.JavaBeanInstanceFactory;
import com.link_intersystems.beans.java.JavaIndexedPropertyDesc;
import com.link_intersystems.beans.java.JavaPropertyDesc;
import com.link_intersystems.beans.java.JavaPropertyDescriptors;
import com.link_intersystems.beans.java.PropertyDescriptor2AccessorsTransformer;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class JavaBeanClass<T>
extends BeanClass<T>
implements Serializable {
    private static final long serialVersionUID = -5446272789930350423L;
    private BeanInfo beanInfo;
    private transient JavaPropertyDescriptors propertyDescriptors;
    private transient List<JavaPropertyDesc> javaPropertyDescs;
    private transient PropertyDescList allProperties;
    private BeanEventTypeList beanEventTypes;

    JavaBeanClass(Class<T> beanType) throws BeanClassException {
        this(beanType, null);
    }

    JavaBeanClass(Class<T> beanType, Class<?> stopClass) throws BeanClassException {
        try {
            this.beanInfo = Introspector.getBeanInfo(beanType, stopClass);
        }
        catch (IntrospectionException e) {
            String msg = MessageFormat.format("Unable to create BeanClass for ''{0}''. Stop at ''{1}''", beanType, stopClass);
            throw new BeanClassException(msg, e);
        }
    }

    @Override
    public String getName() {
        return this.beanInfo.getBeanDescriptor().getName();
    }

    @Override
    public Class<T> getType() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    public JavaPropertyDescriptors getJavaPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = this.createJavaPropertyDescriptors();
        }
        return this.propertyDescriptors;
    }

    private JavaPropertyDescriptors createJavaPropertyDescriptors() throws IllegalStateException {
        PropertyDescriptor[] propertyDescriptors = this.beanInfo.getPropertyDescriptors();
        return new JavaPropertyDescriptors(propertyDescriptors);
    }

    public boolean isPropertyAccessor(Method method) {
        Class<T> beanType;
        Class<T> declaringClass = method.getDeclaringClass();
        boolean isInHierarchy = declaringClass.isAssignableFrom(beanType = this.getType());
        if (!isInHierarchy) {
            return false;
        }
        JavaPropertyDescriptors propertyDescriptors = this.getJavaPropertyDescriptors();
        return propertyDescriptors.stream().anyMatch(pd -> PropertyDescriptor2AccessorsTransformer.INSTANCE.apply((PropertyDescriptor)pd).stream().anyMatch(method::equals));
    }

    @Override
    public BeanInstanceFactory<T> getBeanInstanceFactory(ArgumentResolver argumentResolver) {
        return new JavaBeanInstanceFactory(this);
    }

    @Override
    public BeanEventTypeList getBeanEventTypes() {
        if (this.beanEventTypes == null) {
            this.beanEventTypes = this.createBeanEventTypes();
        }
        return this.beanEventTypes;
    }

    private BeanEventTypeList createBeanEventTypes() {
        EventSetDescriptor[] eventSetDescriptors = this.beanInfo.getEventSetDescriptors();
        List beanEventTypes = Arrays.stream(eventSetDescriptors).map(this::newJavaBeanEventType).collect(Collectors.toList());
        return new BeanEventTypeList(beanEventTypes);
    }

    private JavaBeanEventType newJavaBeanEventType(EventSetDescriptor eventSetDescriptor) {
        return new JavaBeanEventType(this, eventSetDescriptor);
    }

    @Override
    public boolean isListenerSupported(Class<?> listenerClass) {
        BeanEventTypeList beanEvents = this.getBeanEventTypes();
        return beanEvents.stream().anyMatch(be -> be.isApplicable(listenerClass));
    }

    @Override
    public PropertyDescList getAllProperties() {
        if (this.allProperties == null) {
            this.allProperties = new PropertyDescList(this.getJavaPropertyDescs());
        }
        return this.allProperties;
    }

    List<JavaPropertyDesc> getJavaPropertyDescs() {
        if (this.javaPropertyDescs == null) {
            this.javaPropertyDescs = this.getJavaPropertyDescriptors().stream().map(this::toPropertyDesc).collect(Collectors.toList());
        }
        return this.javaPropertyDescs;
    }

    JavaPropertyDesc getPropertyDescByMethod(Method method) {
        return this.getAllProperties().stream().map(JavaPropertyDesc.class::cast).filter((? super T jpd) -> jpd.hasMethod(method)).findFirst().orElse(null);
    }

    private JavaPropertyDesc toPropertyDesc(PropertyDescriptor pd) {
        if (pd instanceof IndexedPropertyDescriptor) {
            return new JavaIndexedPropertyDesc((IndexedPropertyDescriptor)pd);
        }
        return new JavaPropertyDesc(pd);
    }

    public String toString() {
        return "JavaBeanClass{name=" + this.getName() + ", type=" + this.getType().getName() + '}';
    }
}

