/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import com.link_intersystems.beans.BeanEventType;
import com.link_intersystems.beans.java.JavaBeanClass;
import com.link_intersystems.beans.java.JavaBeanEvent;
import java.beans.EventSetDescriptor;
import java.lang.reflect.Method;
import java.text.MessageFormat;

public class JavaBeanEventType
implements BeanEventType {
    private JavaBeanClass<?> javaBeanClass;
    private EventSetDescriptor eventDescriptor;

    JavaBeanEventType(JavaBeanClass<?> javaBeanClass, EventSetDescriptor eventDescriptor) {
        this.javaBeanClass = javaBeanClass;
        this.eventDescriptor = eventDescriptor;
    }

    public EventSetDescriptor getEventDescriptor() {
        return this.eventDescriptor;
    }

    @Override
    public String getName() {
        return this.eventDescriptor.getName();
    }

    @Override
    public JavaBeanEvent newBeanEvent(Object bean) {
        if (!this.javaBeanClass.isInstance(bean)) {
            String msg = MessageFormat.format("''{0}'' is not an instance of ''{1}''", bean, this.javaBeanClass);
            throw new IllegalArgumentException(msg);
        }
        return new JavaBeanEvent(bean, this);
    }

    @Override
    public boolean isApplicable(Object listener) {
        Class<?> listenerType = this.eventDescriptor.getListenerType();
        return listenerType.isInstance(listener);
    }

    @Override
    public boolean isApplicable(Class<?> listenerClass) {
        Class<?> listenerType = this.eventDescriptor.getListenerType();
        return listenerType.isAssignableFrom(listenerClass);
    }

    @Override
    public void addListener(Object bean, Object listener) throws UnsupportedOperationException {
        Method addListenerMethod = this.eventDescriptor.getAddListenerMethod();
        if (addListenerMethod == null) {
            String msg = MessageFormat.format("{0} has no add method", this.eventDescriptor);
            throw new UnsupportedOperationException(msg);
        }
        try {
            addListenerMethod.invoke(bean, listener);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to add listener {0}", listener);
            throw new IllegalArgumentException(msg, e);
        }
    }

    @Override
    public void removeListener(Object bean, Object listener) throws UnsupportedOperationException {
        Method removeListenerMethod = this.eventDescriptor.getRemoveListenerMethod();
        if (removeListenerMethod == null) {
            String msg = MessageFormat.format("{0} has no remove method.", this.eventDescriptor);
            throw new UnsupportedOperationException(msg);
        }
        try {
            removeListenerMethod.invoke(bean, listener);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to remove listener {0}", listener);
            throw new IllegalArgumentException(msg, e);
        }
    }

    public String toString() {
        return "JavaBeanEventType{eventSetDescriptor=" + this.eventDescriptor + '}';
    }
}

