/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import com.link_intersystems.beans.BeanInstanceFactory;
import com.link_intersystems.beans.BeanInstantiationException;
import com.link_intersystems.beans.java.JavaBean;
import com.link_intersystems.beans.java.JavaBeanClass;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class JavaBeanInstanceFactory<T>
implements BeanInstanceFactory<T> {
    private JavaBeanClass<T> javaBeanClass;

    JavaBeanInstanceFactory(JavaBeanClass<T> javaBeanClass) {
        this.javaBeanClass = Objects.requireNonNull(javaBeanClass);
    }

    @Override
    public JavaBean<T> newBeanInstance() {
        Class<T> beanType = this.javaBeanClass.getType();
        try {
            Constructor<T> defaultConstructor = beanType.getDeclaredConstructor(new Class[0]);
            T newBeanObj = defaultConstructor.newInstance(new Object[0]);
            return new JavaBean<T>(this.javaBeanClass, newBeanObj);
        }
        catch (Exception e) {
            String msg = "Bean " + beanType.getCanonicalName() + " throws an exception while invoking the default constructor. Does it have a public default constructor? See BeanClass.getStrict(Class<T>)";
            throw new BeanInstantiationException(msg, e);
        }
    }

    @Override
    public JavaBean<T> fromExistingInstance(T beanObject) {
        return new JavaBean<T>(this.javaBeanClass, beanObject);
    }
}

