/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import com.link_intersystems.beans.IndexedProperty;
import com.link_intersystems.beans.IndexedPropertyDesc;
import com.link_intersystems.beans.PropertyReadException;
import com.link_intersystems.beans.PropertyWriteException;
import com.link_intersystems.beans.java.JavaBean;
import com.link_intersystems.beans.java.JavaBeanClass;
import com.link_intersystems.beans.java.JavaIndexedPropertyDesc;
import com.link_intersystems.beans.java.JavaProperty;
import java.beans.IndexedPropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public class JavaIndexedProperty
extends JavaProperty
implements IndexedProperty {
    private static final long serialVersionUID = 3014890786938775513L;

    JavaIndexedProperty(JavaBean<?> bean, JavaIndexedPropertyDesc indexedPropertyDescriptor) {
        super(bean, indexedPropertyDescriptor);
    }

    @Override
    protected IndexedPropertyDescriptor getJavaPropertyDescriptor() {
        return (IndexedPropertyDescriptor)super.getJavaPropertyDescriptor();
    }

    @Override
    public IndexedPropertyDesc getPropertyDesc() {
        return (IndexedPropertyDesc)super.getPropertyDesc();
    }

    @Override
    public <T> T getValue(int index) {
        JavaBean<?> bean = this.getBean();
        Method indexedReadMethod = this.getIndexedReadMethod();
        if (indexedReadMethod == null) {
            throw new PropertyReadException(((JavaBeanClass)bean.getBeanClass()).getType(), this.getPropertyDesc().getName());
        }
        try {
            Object target = bean.getBeanObject();
            Object elementValue = this.invoke(indexedReadMethod, target, index);
            return (T)elementValue;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new PropertyReadException(((JavaBeanClass)bean.getBeanClass()).getType(), this.getPropertyDesc().getName(), targetException);
        }
        catch (IllegalAccessException e) {
            throw new PropertyReadException(((JavaBeanClass)bean.getBeanClass()).getType(), this.getPropertyDesc().getName(), e);
        }
    }

    public void setValue(int index, Object elementValue) {
        JavaBean<?> bean = this.getBean();
        Method indexedWriteMethod = this.getIndexedWriteMethod();
        if (indexedWriteMethod == null) {
            throw new PropertyWriteException(((JavaBeanClass)bean.getBeanClass()).getType(), this.getPropertyDesc().getName());
        }
        try {
            Object target = bean.getBeanObject();
            this.invoke(indexedWriteMethod, target, index, elementValue);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new PropertyWriteException(((JavaBeanClass)bean.getBeanClass()).getType(), this.getPropertyDesc().getName(), targetException);
        }
        catch (IllegalAccessException e) {
            throw new PropertyWriteException(((JavaBeanClass)bean.getBeanClass()).getType(), this.getPropertyDesc().getName(), e);
        }
    }

    protected final Method getIndexedWriteMethod() {
        return this.getJavaPropertyDescriptor().getIndexedWriteMethod();
    }

    protected final Method getIndexedReadMethod() {
        return this.getJavaPropertyDescriptor().getIndexedReadMethod();
    }

    @Override
    public String toString() {
        return super.getName() + "[]";
    }

    @Override
    public int hashCode() {
        if (this.isReadable()) {
            return this.hashCodeByArray();
        }
        return this.hashCodeByIndex();
    }

    private int hashCodeByArray() {
        Object[] value = (Object[])this.getValue();
        return Arrays.hashCode(value);
    }

    private int hashCodeByIndex() {
        int prime = 31;
        int result = 1;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            try {
                Object value = this.getValue(i);
                result = 31 * result + (value == null ? 0 : value.hashCode());
                continue;
            }
            catch (PropertyReadException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IndexOutOfBoundsException) break;
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        IndexedPropertyDesc otherPropertyDescriptor;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexedProperty other = (IndexedProperty)obj;
        IndexedPropertyDesc propertyDescriptor = this.getPropertyDesc();
        if (!propertyDescriptor.equals(otherPropertyDescriptor = other.getPropertyDesc())) {
            return false;
        }
        if (this.isReadable()) {
            return this.equalsByArray(other);
        }
        return this.equalsByIndex(other);
    }

    private boolean equalsByArray(IndexedProperty other) {
        if (!other.getPropertyDesc().isReadable()) {
            return false;
        }
        Object[] value = (Object[])this.getValue();
        Object[] otherValue = (Object[])other.getValue();
        return Arrays.equals(value, otherValue);
    }

    private boolean equalsByIndex(IndexedProperty other) {
        boolean equal = true;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            try {
                Object value = this.getValue(i);
                try {
                    Object otherValue = other.getValue(i);
                    equal = Objects.equals(value, otherValue);
                    if (equal) continue;
                    break;
                }
                catch (PropertyReadException e) {
                    equal = false;
                    Throwable cause = e.getCause();
                    if (cause instanceof IndexOutOfBoundsException) break;
                    throw new RuntimeException(e);
                }
            }
            catch (PropertyReadException e) {
                block7: {
                    try {
                        other.getValue(i);
                        equal = false;
                    }
                    catch (PropertyReadException pe) {
                        Throwable cause = pe.getCause();
                        if (cause instanceof IndexOutOfBoundsException) break block7;
                        throw new RuntimeException(e);
                    }
                }
                Throwable cause = e.getCause();
                if (cause instanceof IndexOutOfBoundsException) break;
                throw new RuntimeException(e);
            }
        }
        return equal;
    }
}

