/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import com.link_intersystems.beans.Property;
import com.link_intersystems.beans.PropertyDesc;
import com.link_intersystems.beans.PropertyEditorNotAvailableException;
import com.link_intersystems.beans.java.JavaBean;
import com.link_intersystems.beans.java.JavaPropertyDesc;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;

public class JavaProperty
implements Serializable,
Property {
    private static final long serialVersionUID = -6759158627808430975L;
    private JavaBean<?> bean;
    private JavaPropertyDesc propertyDescriptor;

    JavaProperty(JavaBean<?> bean, JavaPropertyDesc propertyDescriptor) {
        this.bean = Objects.requireNonNull(bean);
        this.propertyDescriptor = Objects.requireNonNull(propertyDescriptor);
    }

    protected PropertyDescriptor getJavaPropertyDescriptor() {
        return this.propertyDescriptor.getJavaPropertyDescriptor();
    }

    @Override
    public PropertyDesc getPropertyDesc() {
        return this.propertyDescriptor;
    }

    protected final JavaBean<?> getBean() {
        return this.bean;
    }

    public String getName() {
        return this.getPropertyDesc().getName();
    }

    public PropertyEditor createPropertiyEditor() throws PropertyEditorNotAvailableException {
        JavaBean<?> beanObj = this.getBean();
        Object bean = beanObj.getBeanObject();
        PropertyDescriptor javaPropertyDescriptor = this.getJavaPropertyDescriptor();
        PropertyEditor propertyEditor = javaPropertyDescriptor.createPropertyEditor(bean);
        if (propertyEditor == null) {
            Class<?> propertyType = this.getPropertyDesc().getType();
            propertyEditor = PropertyEditorManager.findEditor(propertyType);
        }
        if (propertyEditor == null) {
            String msg = MessageFormat.format("No property editor available for {0}", this);
            throw new PropertyEditorNotAvailableException(msg);
        }
        return propertyEditor;
    }

    public String getValueAsText() throws PropertyEditorNotAvailableException {
        try {
            PropertyEditor propertiyEditor = this.createPropertiyEditor();
            propertiyEditor.setValue(this.getValue());
            return propertiyEditor.getAsText();
        }
        catch (PropertyEditorNotAvailableException e) {
            return null;
        }
    }

    public void setValueAsText(String text) throws PropertyEditorNotAvailableException {
        PropertyEditor propertiyEditor = this.createPropertiyEditor();
        propertiyEditor.setAsText(text);
        Object value = propertiyEditor.getValue();
        this.setValue(value);
    }

    @Override
    public <T> T getValue() {
        PropertyDesc propertyDesc = this.getPropertyDesc();
        return propertyDesc.getPropertyValue(this.bean.getBeanObject());
    }

    @Override
    public void setValue(Object propertyValue) {
        PropertyDesc propertyDesc = this.getPropertyDesc();
        propertyDesc.setPropertyValue(this.bean.getBeanObject(), propertyValue);
    }

    protected Object invoke(Method method, Object target, Object ... args) throws IllegalAccessException, InvocationTargetException {
        Object beanValue = method.invoke(target, args);
        return beanValue;
    }

    public boolean isReadable() {
        return this.getPropertyDesc().isReadable();
    }

    public boolean isWritable() {
        return this.getPropertyDesc().isWritable();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.propertyDescriptor.hashCode();
        Object value = this.getValue();
        if (value != null) {
            Class<?> valueClass = value.getClass();
            result = valueClass.isArray() ? 31 * result + Arrays.deepHashCode((Object[])value) : 31 * result + value.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaProperty other = (JavaProperty)obj;
        if (!this.propertyDescriptor.equals(other.propertyDescriptor)) {
            return false;
        }
        Object value = this.getValue();
        if (value == null) {
            return other.getValue() == null;
        }
        Object otherValue = other.getValue();
        if (otherValue == null) {
            return false;
        }
        Class<?> valueClass = value.getClass();
        Class<?> otherValueClass = otherValue.getClass();
        if (valueClass.isArray() && otherValueClass.isArray()) {
            return Objects.deepEquals(value, otherValue);
        }
        if (!valueClass.isArray() && !otherValueClass.isArray()) {
            return value.equals(otherValue);
        }
        return false;
    }

    public Class<?> getDeclaringClass() {
        return this.getPropertyDesc().getDeclaringClass();
    }
}

