/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import com.link_intersystems.beans.PropertyDesc;
import com.link_intersystems.beans.PropertyReadException;
import com.link_intersystems.beans.PropertyWriteException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Objects;

public class JavaPropertyDesc
implements PropertyDesc {
    private PropertyDescriptor propertyDescriptor;
    private Class<?> type;

    JavaPropertyDesc(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = Objects.requireNonNull(propertyDescriptor);
    }

    @Override
    public <T> T getPropertyValue(Object bean) throws PropertyReadException {
        PropertyDescriptor javaPropertyDescriptor = this.getJavaPropertyDescriptor();
        Method readMethod = javaPropertyDescriptor.getReadMethod();
        if (readMethod == null) {
            throw new PropertyReadException(bean.getClass(), this.getName());
        }
        try {
            Object beanValue = this.invoke(readMethod, bean, new Object[0]);
            return (T)beanValue;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PropertyReadException(bean.getClass(), this.getName(), e);
        }
    }

    @Override
    public void setPropertyValue(Object bean, Object value) {
        PropertyDescriptor javaPropertyDescriptor = this.getJavaPropertyDescriptor();
        Method writeMethod = javaPropertyDescriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new PropertyWriteException(bean.getClass(), this.getName());
        }
        try {
            this.invoke(writeMethod, bean, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PropertyWriteException(bean.getClass(), this.getName(), e);
        }
    }

    protected Object invoke(Method method, Object target, Object ... args) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(target, args);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaPropertyDesc that = (JavaPropertyDesc)o;
        return Objects.equals(this.propertyDescriptor, that.propertyDescriptor) && Objects.equals(this.type, that.type);
    }

    @Override
    public String getName() {
        return this.propertyDescriptor.getName();
    }

    @Override
    public Class<?> getType() {
        if (this.type == null) {
            Method readMethod = this.propertyDescriptor.getReadMethod();
            if (readMethod != null) {
                this.type = readMethod.getReturnType();
            } else {
                Method writeMethod = this.propertyDescriptor.getWriteMethod();
                Class<?>[] parameterTypes = writeMethod.getParameterTypes();
                this.type = parameterTypes[0];
            }
        }
        return this.type;
    }

    @Override
    public boolean isReadable() {
        return this.propertyDescriptor.getReadMethod() != null;
    }

    @Override
    public boolean isWritable() {
        return this.propertyDescriptor.getWriteMethod() != null;
    }

    public PropertyDescriptor getJavaPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    @Override
    public Class<?> getDeclaringClass() {
        Method readMethod = this.propertyDescriptor.getReadMethod();
        Method writeMethod = this.propertyDescriptor.getWriteMethod();
        if (readMethod != null && writeMethod == null) {
            return readMethod.getDeclaringClass();
        }
        if (readMethod == null && writeMethod != null) {
            return writeMethod.getDeclaringClass();
        }
        if (readMethod != null) {
            Class<?> writeDeclaringClass;
            Class<?> readDeclaringClass = readMethod.getDeclaringClass();
            if (readDeclaringClass.equals(writeDeclaringClass = writeMethod.getDeclaringClass()) || readDeclaringClass.isAssignableFrom(writeDeclaringClass)) {
                return readDeclaringClass;
            }
            return writeDeclaringClass;
        }
        String msg = MessageFormat.format("Can not determine declaring class of property {0}. Read and write method is null.", this);
        throw new IllegalStateException(msg);
    }

    public boolean isReadMethod(Method method) {
        if (method == null) {
            return false;
        }
        PropertyDescriptor javaPropertyDescriptor = this.getJavaPropertyDescriptor();
        Method readMethod = javaPropertyDescriptor.getReadMethod();
        return method.equals(readMethod);
    }

    public boolean isWriteMethod(Method method) {
        if (method == null) {
            return false;
        }
        PropertyDescriptor javaPropertyDescriptor = this.getJavaPropertyDescriptor();
        Method writeMethod = javaPropertyDescriptor.getWriteMethod();
        return method.equals(writeMethod);
    }

    public boolean hasMethod(Method method) {
        return this.isReadMethod(method) || this.isWriteMethod(method);
    }

    public int hashCode() {
        return Objects.hash(this.propertyDescriptor, this.type);
    }
}

