/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.beans.java;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class MergedAdditionalBeanInfo
extends SimpleBeanInfo {
    private BeanInfo mainBeanInfo;
    private boolean includeMainBeanInfo = true;

    public MergedAdditionalBeanInfo(BeanInfo mainBeanInfo) {
        this.mainBeanInfo = Objects.requireNonNull(mainBeanInfo);
    }

    public void setIncludeMainBeanInfo(boolean includeMainBeanInfo) {
        this.includeMainBeanInfo = includeMainBeanInfo;
    }

    public boolean isIncludeMainBeanInfo() {
        return this.includeMainBeanInfo;
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.getDescriptors(BeanInfo::getEventSetDescriptors, EventSetDescriptor.class);
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.getDescriptors(BeanInfo::getPropertyDescriptors, PropertyDescriptor.class);
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.getDescriptors(BeanInfo::getMethodDescriptors, MethodDescriptor.class);
    }

    private <T> T[] getDescriptors(Function<BeanInfo, T[]> descriptorGetter, Class<T> descriptorType) {
        return this.getBeanInfos().stream().map(descriptorGetter).map(Arrays::asList).flatMap(Collection::stream).toArray(length -> (Object[])Array.newInstance(descriptorType, length));
    }

    private List<BeanInfo> getBeanInfos() {
        BeanInfo[] additionalBeanInfo;
        ArrayList<BeanInfo> allBeanInfos = new ArrayList<BeanInfo>();
        if (this.includeMainBeanInfo) {
            allBeanInfos.add(this.mainBeanInfo);
        }
        if ((additionalBeanInfo = this.getAdditionalBeanInfo()) != null) {
            allBeanInfos.addAll(Arrays.asList(additionalBeanInfo));
        }
        return allBeanInfos;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.mainBeanInfo.getBeanDescriptor();
    }

    @Override
    public int getDefaultEventIndex() {
        return this.mainBeanInfo.getDefaultEventIndex();
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.mainBeanInfo.getDefaultPropertyIndex();
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return this.mainBeanInfo.getAdditionalBeanInfo();
    }

    @Override
    public Image getIcon(int iconKind) {
        return this.mainBeanInfo.getIcon(iconKind);
    }
}

