/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.gradle.publication.maven;

import com.link_intersystems.gradle.publication.ArtifactCoordinates;
import com.link_intersystems.gradle.publication.maven.MavenArtifactCoordinatesFormat;
import java.util.Objects;

public class MavenArtifactCoordinates
implements ArtifactCoordinates {
    private String groupId;
    private String artifactId;
    private String version;
    private String extension;
    private String classifier;

    public MavenArtifactCoordinates(String groupId, String artifactId, String version, String extension) {
        this(groupId, artifactId, version, extension, null);
    }

    public MavenArtifactCoordinates(String groupId, String artifactId, String version, String extension, String classifier) {
        this.groupId = MavenArtifactCoordinates.requireNonBlank(groupId, "groupId must not be blank.");
        this.artifactId = MavenArtifactCoordinates.requireNonBlank(artifactId, "artifactId must not be blank.");
        this.version = MavenArtifactCoordinates.requireNonBlank(version, "version must not be blank.");
        this.extension = MavenArtifactCoordinates.requireNonBlank(extension, "extension must not be blank.");
        this.classifier = classifier == null ? null : MavenArtifactCoordinates.requireNonBlank(classifier, "classifier must not be blank if provided.");
    }

    private static String requireNonBlank(String value, String message) {
        String nonNullValue = Objects.requireNonNull(value, message);
        if (nonNullValue.isBlank()) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getGroup() {
        return this.getGroupId();
    }

    @Override
    public String getName() {
        return this.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String getExtension() {
        return this.extension;
    }

    public MavenArtifactCoordinates withVersion(String version) {
        return new MavenArtifactCoordinates(this.groupId, this.artifactId, version, this.extension, this.classifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifactCoordinates that = (MavenArtifactCoordinates)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.extension, that.extension) && Objects.equals(this.classifier, that.classifier);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.extension, this.classifier);
    }

    public String toString() {
        return MavenArtifactCoordinatesFormat.formatMavenArtifact(this);
    }
}

