/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.gradle.publication.maven;

import com.link_intersystems.gradle.publication.maven.MavenArtifactCoordinates;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.jetbrains.annotations.NotNull;

public class MavenArtifactCoordinatesFormat
extends Format {
    public static String formatMavenArtifact(MavenArtifactCoordinates mavenArtifactCoordinates) {
        return new MavenArtifactCoordinatesFormat().format(mavenArtifactCoordinates);
    }

    public final String format(MavenArtifactCoordinates mavenArtifact) {
        return this.format((Object)mavenArtifact, new StringBuffer(), new FieldPosition(0)).toString();
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof MavenArtifactCoordinates) {
            return this.format((MavenArtifactCoordinates)obj, toAppendTo, pos);
        }
        throw new IllegalArgumentException("Cannot format given Object as a MavenArtifact.");
    }

    public StringBuffer format(MavenArtifactCoordinates mavenArtifact, StringBuffer toAppendTo, FieldPosition pos) {
        toAppendTo = toAppendTo.append(mavenArtifact.getGroupId()).append(':').append(mavenArtifact.getArtifactId()).append(':').append(mavenArtifact.getVersion()).append(':').append(mavenArtifact.getExtension());
        if (mavenArtifact.getClassifier() != null) {
            toAppendTo.append(':').append(mavenArtifact.getClassifier());
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, @NotNull ParsePosition pos) {
        return null;
    }

    public MavenArtifactCoordinates parse(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        return this.parse(source, pos);
    }

    public MavenArtifactCoordinates parse(String text, ParsePosition pos) throws ParseException {
        int textLength = text.length();
        StringBuilder partBuilder = new StringBuilder();
        ArtifactCoordinates cords = new ArtifactCoordinates();
        while (pos.getIndex() < textLength) {
            if (cords.isComplete()) {
                pos.setErrorIndex(pos.getIndex());
                break;
            }
            char charAt = text.charAt(pos.getIndex());
            if (charAt == ':') {
                cords.add(partBuilder);
                partBuilder = new StringBuilder();
            } else if (Character.isWhitespace(charAt)) {
                pos.setErrorIndex(pos.getIndex());
            } else {
                partBuilder.append(charAt);
            }
            pos.setIndex(pos.getIndex() + 1);
        }
        if (partBuilder.length() > 0) {
            cords.add(partBuilder);
        }
        if (!cords.isValid()) {
            pos.setErrorIndex(pos.getIndex());
        }
        if (pos.getErrorIndex() != -1) {
            String message = MavenArtifactCoordinatesFormat.createExceptionMessage(cords, pos);
            throw new ParseException(message, pos.getErrorIndex());
        }
        return cords.build();
    }

    @NotNull
    private static String createExceptionMessage(ArtifactCoordinates cords, ParsePosition pos) {
        String partName = cords.nextPartName();
        String message = partName == null ? "unknown artifact coordinate element at " + pos.getErrorIndex() : "Missing " + partName;
        return message;
    }

    private static class ArtifactCoordinates {
        private String[] partNames = new String[]{"groupId", "artifactId", "version", "extension", "classifier"};
        private String[] parts = new String[5];
        private int partsIndex = 0;

        private ArtifactCoordinates() {
        }

        public void add(CharSequence part) {
            this.parts[this.partsIndex++] = part.toString();
        }

        public boolean isComplete() {
            return this.partsIndex == this.parts.length;
        }

        public boolean isValid() {
            return this.partsIndex > 3;
        }

        public String nextPartName() {
            return this.partsIndex < this.parts.length ? this.partNames[this.partsIndex] : null;
        }

        public MavenArtifactCoordinates build() {
            return new MavenArtifactCoordinates(this.parts[0], this.parts[1], this.parts[2], this.parts[3], this.parts[4]);
        }
    }
}

