/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.gradle.publication.maven;

import com.link_intersystems.gradle.publication.ArtifactCoordinates;
import com.link_intersystems.gradle.publication.ArtifactRepository;
import com.link_intersystems.gradle.publication.maven.MavenArtifactCoordinates;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

public class MavenArtifactRepository
implements ArtifactRepository {
    private final ExternalResourceRepository externalResourceRepository;
    private org.gradle.api.artifacts.repositories.MavenArtifactRepository mavenArtifactRepository;

    public MavenArtifactRepository(org.gradle.api.artifacts.repositories.MavenArtifactRepository mavenArtifactRepository) {
        this.mavenArtifactRepository = mavenArtifactRepository;
        String protocol = mavenArtifactRepository.getUrl().getScheme().toLowerCase();
        DefaultMavenArtifactRepository realRepository = (DefaultMavenArtifactRepository)mavenArtifactRepository;
        RepositoryTransport transport = realRepository.getTransport(protocol);
        this.externalResourceRepository = transport.getRepository();
    }

    @Override
    public boolean exists(ArtifactCoordinates artifactCoordinates) {
        if (!(artifactCoordinates instanceof MavenArtifactCoordinates)) {
            throw new IllegalArgumentException("artifact must be a MavenArtifact.");
        }
        MavenArtifactCoordinates mavenArtifact = (MavenArtifactCoordinates)artifactCoordinates;
        ExternalResourceName externalResourceName = this.toExternalResourceName(mavenArtifact);
        ExternalResource externalResource = this.externalResourceRepository.resource(externalResourceName);
        ExternalResourceMetaData metaData = externalResource.getMetaData();
        return metaData != null && !metaData.wasMissing();
    }

    public ExternalResourceName toExternalResourceName(MavenArtifactCoordinates mavenArtifact) {
        String repositoryRelativePath = this.toRepositoryRelativePath(mavenArtifact);
        return new ExternalResourceName(this.mavenArtifactRepository.getUrl(), repositoryRelativePath);
    }

    private String toRepositoryRelativePath(MavenArtifactCoordinates mavenArtifact) {
        String extension;
        String artifactId = mavenArtifact.getArtifactId();
        String artifactVersion = mavenArtifact.getVersion();
        StringBuilder path = new StringBuilder(this.toRepositoryRelativeBasePath(mavenArtifact));
        path.append(artifactId).append('-').append(artifactVersion);
        String classifier = mavenArtifact.getClassifier();
        if (classifier != null) {
            path.append('-').append(classifier);
        }
        if (!(extension = mavenArtifact.getExtension()).isEmpty()) {
            path.append('.').append(extension);
        }
        return path.toString();
    }

    private CharSequence toRepositoryRelativeBasePath(MavenArtifactCoordinates mavenArtifact) {
        String groupId = mavenArtifact.getGroupId();
        String artifactId = mavenArtifact.getArtifactId();
        String moduleVersion = mavenArtifact.getVersion();
        StringBuilder path = new StringBuilder(128);
        String groupPath = groupId.replace('.', '/');
        path.append(groupPath).append('/');
        path.append(artifactId).append('/');
        path.append(moduleVersion).append('/');
        return path;
    }

    private ExternalResourceName getMetaDataResourceName(MavenArtifactCoordinates mavenArtifact) {
        StringBuilder path = new StringBuilder(this.toRepositoryRelativeBasePath(mavenArtifact));
        path.append("maven-metadata.xml");
        return new ExternalResourceName(this.mavenArtifactRepository.getUrl(), path.toString());
    }
}

