/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.gradle.publication.plugins.verify;

import com.link_intersystems.gradle.publication.ArtifactCoordinates;
import com.link_intersystems.gradle.publication.ArtifactPublication;
import com.link_intersystems.gradle.publication.ArtifactRepository;
import com.link_intersystems.gradle.publication.plugins.ArtifactFilter;
import com.link_intersystems.gradle.publication.plugins.ArtifactRepositoryDesc;
import com.link_intersystems.gradle.publication.plugins.verify.VerifyPublicationArtifactResult;
import com.link_intersystems.gradle.publication.plugins.verify.VerifyPublicationConfig;
import com.link_intersystems.gradle.publication.plugins.verify.VerifyPublicationResult;
import com.link_intersystems.gradle.publication.plugins.verify.VerifyPublicationResultHandler;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class VerifyPublicationTask
extends DefaultTask {
    private final ArtifactPublication artifactPublication;
    private final VerifyPublicationConfig verifyPublicationConfig;

    @Inject
    public VerifyPublicationTask(ArtifactPublication artifactPublication, VerifyPublicationConfig verifyPublicationConfig) {
        this.verifyPublicationConfig = verifyPublicationConfig;
        this.artifactPublication = artifactPublication;
    }

    @TaskAction
    public void verifyPublication() {
        List<? extends ArtifactCoordinates> artifacts = this.artifactPublication.getArtifactCoordinates();
        ArtifactRepository artifactRepository = this.artifactPublication.getArtifactRepository();
        ArtifactRepositoryDesc repositoryDesc = this.artifactPublication.getArtifactRepositoryDesc();
        ArrayList<VerifyPublicationArtifactResult> verifyResults = new ArrayList<VerifyPublicationArtifactResult>();
        ArtifactFilter<ArtifactCoordinates> artifactFilter = this.verifyPublicationConfig.getFilter();
        for (ArtifactCoordinates artifactCoordinates : artifacts) {
            if (artifactFilter.accept(artifactCoordinates)) {
                boolean exists = artifactRepository.exists(artifactCoordinates);
                verifyResults.add(new VerifyPublicationArtifactResult(artifactCoordinates, exists));
                continue;
            }
            this.getLogger().debug("Skip artifact '{}', because the artifact filter '{}' does not accept it", (Object)artifactCoordinates, artifactFilter);
        }
        VerifyPublicationResultHandler verifyPublicationResultHandler = this.verifyPublicationConfig.getMode();
        verifyPublicationResultHandler.handle(new VerifyPublicationResult(repositoryDesc, verifyResults));
    }
}

