/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.gradle.publication.plugins.verify;

import com.link_intersystems.gradle.publication.ArtifactPublication;
import com.link_intersystems.gradle.publication.plugins.verify.VerifyPublication;
import com.link_intersystems.gradle.publication.plugins.verify.VerifyPublicationConfig;
import com.link_intersystems.gradle.publication.plugins.verify.VerifyPublicationTask;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyPublicationTaskRegistrar {
    private Logger logger = LoggerFactory.getLogger(VerifyPublicationTaskRegistrar.class);
    private final Project project;

    public VerifyPublicationTaskRegistrar(Project project) {
        this.project = project;
    }

    public void registerTask(VerifyPublication verifyPublication) {
        VerifyPublicationConfig verifyPublicationConfig = new VerifyPublicationConfig(verifyPublication);
        List<ArtifactPublication> artifactPublications = verifyPublication.getArtifactPublications(this.project);
        for (ArtifactPublication artifactPublication : artifactPublications) {
            this.registerTask(artifactPublication, verifyPublicationConfig);
        }
    }

    public void registerTask(ArtifactPublication artifactPublication, VerifyPublicationConfig verifyPublicationConfig) {
        String publicationName = artifactPublication.getPublicationName();
        String repositoryName = artifactPublication.getArtifactRepositoryDesc().getName();
        String taskName = "verify" + VerifyPublicationTaskRegistrar.capitalize(publicationName) + "PublicationTo" + VerifyPublicationTaskRegistrar.capitalize(repositoryName) + "Repository";
        TaskContainer tasks = this.project.getTasks();
        TaskProvider publishingCheckTaskTaskProvider = tasks.register(taskName, VerifyPublicationTask.class, new Object[]{artifactPublication, verifyPublicationConfig});
        publishingCheckTaskTaskProvider.configure(task -> task.setGroup("publications"));
    }

    public static String capitalize(String str) {
        int codePoint;
        int newCodePoint;
        int strLen = str.length();
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codePoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }
}

