/*
 * Decompiled with CFR 0.152.
 */
package com.link_intersystems.gradle.publication.plugins.verify;

import com.link_intersystems.gradle.publication.plugins.PublicationServices;
import com.link_intersystems.gradle.publication.plugins.PublicationUtil;
import com.link_intersystems.gradle.publication.plugins.PublicationUtilsExtension;
import com.link_intersystems.gradle.publication.plugins.verify.DefaultVerifyPublicationContainer;
import com.link_intersystems.gradle.publication.plugins.verify.VerifyPublication;
import com.link_intersystems.gradle.publication.plugins.verify.VerifyPublicationContainer;
import com.link_intersystems.gradle.publication.plugins.verify.VerifyPublicationTaskRegistrar;
import com.link_intersystems.gradle.publication.plugins.verify.maven.VerifyMavenPublication;
import com.link_intersystems.gradle.publication.plugins.verify.maven.VerifyMavenPublicationFactory;
import java.util.Map;
import java.util.SortedMap;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.publish.PublishingExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyPublicationUtil
implements PublicationUtil {
    private Logger logger = LoggerFactory.getLogger(VerifyPublicationUtil.class);

    @Override
    public void apply(Project project, PublicationServices publicationServices) {
        ExtensionContainer utilsExtensionContainer = publicationServices.getUtilsExtensionContainer();
        VerifyPublicationContainer verifyPublicationContainer = (VerifyPublicationContainer)utilsExtensionContainer.create(VerifyPublicationContainer.class, "verify", DefaultVerifyPublicationContainer.class, new Object[0]);
        RepositoryHandler repositoryHandler = publicationServices.createRepositoryHandler();
        verifyPublicationContainer.registerFactory(VerifyMavenPublication.class, new VerifyMavenPublicationFactory(repositoryHandler));
        project.afterEvaluate(this::registerVerifyPublicationTasks);
    }

    private void registerVerifyPublicationTasks(Project project) {
        PublishingExtension publishingExtension = (PublishingExtension)project.getExtensions().findByType(PublishingExtension.class);
        if (publishingExtension == null) {
            this.logger.error("No publishing extension found. Verify publication tasks will not be added to build. Add a publishing plugin like `maven-publish` to the project.");
            return;
        }
        PublicationUtilsExtension publicationUtilsExtension = (PublicationUtilsExtension)project.getExtensions().findByType(PublicationUtilsExtension.class);
        VerifyPublicationTaskRegistrar taskRegistrar = new VerifyPublicationTaskRegistrar(project);
        VerifyPublicationContainer verifyPublicationContainer = (VerifyPublicationContainer)publicationUtilsExtension.getExtensions().getByType(VerifyPublicationContainer.class);
        SortedMap verifyPublications = verifyPublicationContainer.getAsMap();
        for (Map.Entry verifyPublicationEntry : verifyPublications.entrySet()) {
            VerifyPublication verifyPublication = (VerifyPublication)verifyPublicationEntry.getValue();
            taskRegistrar.registerTask(verifyPublication);
        }
    }
}

