/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableNode;
import azkaban.executor.Status;
import azkaban.flow.Edge;
import azkaban.flow.Flow;
import azkaban.flow.FlowProps;
import azkaban.flow.Node;
import azkaban.project.Project;
import azkaban.utils.TypedMapWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableFlowBase
extends ExecutableNode {
    public static final String FLOW_ID_PARAM = "flowId";
    public static final String NODES_PARAM = "nodes";
    public static final String PROPERTIES_PARAM = "properties";
    public static final String SOURCE_PARAM = "source";
    public static final String INHERITED_PARAM = "inherited";
    private static final Logger logger = LoggerFactory.getLogger(ExecutableFlowBase.class);
    private final HashMap<String, ExecutableNode> executableNodes = new HashMap();
    private final HashMap<String, FlowProps> flowProps = new HashMap();
    private ArrayList<String> startNodes;
    private ArrayList<String> endNodes;
    private String flowId;

    public ExecutableFlowBase(Project project, Node node, Flow flow, ExecutableFlowBase parent) {
        super(node, parent);
        this.setFlow(project, flow);
    }

    public ExecutableFlowBase() {
    }

    public int getExecutionId() {
        if (this.getParentFlow() != null) {
            return this.getParentFlow().getExecutionId();
        }
        return -1;
    }

    public int getProjectId() {
        if (this.getParentFlow() != null) {
            return this.getParentFlow().getProjectId();
        }
        return -1;
    }

    public String getProjectName() {
        if (this.getParentFlow() != null) {
            return this.getParentFlow().getProjectName();
        }
        return null;
    }

    public int getVersion() {
        if (this.getParentFlow() != null) {
            return this.getParentFlow().getVersion();
        }
        return -1;
    }

    public String getLastModifiedByUser() {
        if (this.getParentFlow() != null) {
            return this.getParentFlow().getLastModifiedByUser();
        }
        return null;
    }

    public long getLastModifiedTimestamp() {
        if (this.getParentFlow() != null) {
            return this.getParentFlow().getLastModifiedTimestamp();
        }
        return -1L;
    }

    public Collection<FlowProps> getFlowProps() {
        return this.flowProps.values();
    }

    public String getFlowId() {
        return this.flowId;
    }

    protected void setFlow(Project project, Flow flow) {
        this.flowId = flow.getId();
        this.flowProps.putAll(flow.getAllFlowProps());
        for (Node node : flow.getNodes()) {
            String id = node.getId();
            if (node.getType().equals("flow")) {
                String embeddedFlowId = node.getEmbeddedFlowId();
                Flow subFlow = project.getFlow(embeddedFlowId);
                ExecutableFlowBase embeddedFlow = new ExecutableFlowBase(project, node, subFlow, this);
                this.executableNodes.put(id, embeddedFlow);
                continue;
            }
            ExecutableNode exNode = new ExecutableNode(node, this);
            this.executableNodes.put(id, exNode);
        }
        for (Edge edge : flow.getEdges()) {
            ExecutableNode sourceNode = this.executableNodes.get(edge.getSourceId());
            ExecutableNode targetNode = this.executableNodes.get(edge.getTargetId());
            if (sourceNode == null) {
                logger.info("Source node " + edge.getSourceId() + " doesn't exist");
            }
            sourceNode.addOutNode(edge.getTargetId());
            targetNode.addInNode(edge.getSourceId());
        }
    }

    public List<ExecutableNode> getExecutableNodes() {
        return new ArrayList<ExecutableNode>(this.executableNodes.values());
    }

    public ExecutableNode getExecutableNode(String id) {
        return this.executableNodes.get(id);
    }

    public ExecutableNode getExecutableNodePath(String ids) {
        String[] split = ids.split(":");
        return this.getExecutableNodePath(split);
    }

    public ExecutableNode getExecutableNodePath(String ... ids) {
        return this.getExecutableNodePath(this, ids, 0);
    }

    private ExecutableNode getExecutableNodePath(ExecutableFlowBase flow, String[] ids, int currentIdIdx) {
        ExecutableNode node = flow.getExecutableNode(ids[currentIdIdx]);
        ++currentIdIdx;
        if (node == null) {
            return null;
        }
        if (ids.length == currentIdIdx) {
            return node;
        }
        if (node instanceof ExecutableFlowBase) {
            return this.getExecutableNodePath((ExecutableFlowBase)node, ids, currentIdIdx);
        }
        return null;
    }

    public List<String> getStartNodes() {
        if (this.startNodes == null) {
            this.startNodes = new ArrayList();
            for (ExecutableNode node : this.executableNodes.values()) {
                if (!node.getInNodes().isEmpty()) continue;
                this.startNodes.add(node.getId());
            }
        }
        return this.startNodes;
    }

    public List<String> getEndNodes() {
        if (this.endNodes == null) {
            this.endNodes = new ArrayList();
            for (ExecutableNode node : this.executableNodes.values()) {
                if (!node.getOutNodes().isEmpty()) continue;
                this.endNodes.add(node.getId());
            }
        }
        return this.endNodes;
    }

    @Override
    public Map<String, Object> toObject() {
        HashMap<String, Object> mapObj = new HashMap<String, Object>();
        this.fillMapFromExecutable(mapObj);
        return mapObj;
    }

    @Override
    protected void fillMapFromExecutable(Map<String, Object> flowObjMap) {
        super.fillMapFromExecutable(flowObjMap);
        flowObjMap.put(FLOW_ID_PARAM, this.flowId);
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        for (ExecutableNode node : this.executableNodes.values()) {
            nodes.add(node.toObject());
        }
        flowObjMap.put(NODES_PARAM, nodes);
        ArrayList props = new ArrayList();
        for (FlowProps fprop : this.flowProps.values()) {
            HashMap<String, String> propObj = new HashMap<String, String>();
            String source = fprop.getSource();
            String inheritedSource = fprop.getInheritedSource();
            propObj.put(SOURCE_PARAM, source);
            if (inheritedSource != null) {
                propObj.put(INHERITED_PARAM, inheritedSource);
            }
            props.add(propObj);
        }
        flowObjMap.put(PROPERTIES_PARAM, props);
    }

    @Override
    public void fillExecutableFromMapObject(TypedMapWrapper<String, Object> flowObjMap) {
        super.fillExecutableFromMapObject(flowObjMap);
        this.flowId = flowObjMap.getString(FLOW_ID_PARAM);
        List nodes = flowObjMap.getList(NODES_PARAM);
        if (nodes != null) {
            for (Object nodeObj : nodes) {
                Map nodeObjMap = (Map)nodeObj;
                TypedMapWrapper<String, Object> wrapper = new TypedMapWrapper<String, Object>(nodeObjMap);
                String type = wrapper.getString("type");
                if (type != null && type.equals("flow")) {
                    ExecutableFlowBase exFlow = new ExecutableFlowBase();
                    exFlow.fillExecutableFromMapObject(wrapper);
                    exFlow.setParentFlow(this);
                    this.executableNodes.put(exFlow.getId(), exFlow);
                    continue;
                }
                ExecutableNode exJob = new ExecutableNode();
                exJob.fillExecutableFromMapObject(nodeObjMap);
                exJob.setParentFlow(this);
                this.executableNodes.put(exJob.getId(), exJob);
            }
        }
        List properties = flowObjMap.getList(PROPERTIES_PARAM);
        for (Object propNode : properties) {
            HashMap fprop = (HashMap)propNode;
            String source = (String)fprop.get(SOURCE_PARAM);
            String inheritedSource = (String)fprop.get(INHERITED_PARAM);
            FlowProps flowProps = new FlowProps(inheritedSource, source);
            this.flowProps.put(source, flowProps);
        }
    }

    public Map<String, Object> toUpdateObject(long lastUpdateTime) {
        Map<String, Object> updateData = super.toUpdateObject();
        ArrayList<Map<String, Object>> updatedNodes = new ArrayList<Map<String, Object>>();
        for (ExecutableNode node : this.executableNodes.values()) {
            Map<String, Object> updatedNodeMap;
            if (node instanceof ExecutableFlowBase) {
                updatedNodeMap = ((ExecutableFlowBase)node).toUpdateObject(lastUpdateTime);
                if (node.getUpdateTime() <= lastUpdateTime && !updatedNodeMap.containsKey(NODES_PARAM)) continue;
                updatedNodes.add(updatedNodeMap);
                continue;
            }
            if (node.getUpdateTime() <= lastUpdateTime) continue;
            updatedNodeMap = node.toUpdateObject();
            updatedNodes.add(updatedNodeMap);
        }
        if (!updatedNodes.isEmpty()) {
            updateData.put(NODES_PARAM, updatedNodes);
        }
        return updateData;
    }

    public void applyUpdateObject(TypedMapWrapper<String, Object> updateData, List<ExecutableNode> updatedNodes) {
        List nodes;
        super.applyUpdateObject(updateData);
        if (updatedNodes != null) {
            updatedNodes.add(this);
        }
        if ((nodes = updateData.getList(NODES_PARAM)) != null) {
            for (Map node : nodes) {
                TypedMapWrapper<String, Object> nodeWrapper = new TypedMapWrapper<String, Object>(node);
                String id = nodeWrapper.getString("id");
                if (id == null) {
                    id = nodeWrapper.getString("jobId");
                }
                ExecutableNode exNode = this.executableNodes.get(id);
                if (updatedNodes != null) {
                    updatedNodes.add(exNode);
                }
                if (exNode instanceof ExecutableFlowBase) {
                    ((ExecutableFlowBase)exNode).applyUpdateObject(nodeWrapper, updatedNodes);
                    continue;
                }
                exNode.applyUpdateObject(nodeWrapper);
            }
        }
    }

    public void applyUpdateObject(Map<String, Object> updateData, List<ExecutableNode> updatedNodes) {
        TypedMapWrapper<String, Object> typedMapWrapper = new TypedMapWrapper<String, Object>(updateData);
        this.applyUpdateObject(typedMapWrapper, updatedNodes);
    }

    @Override
    public void applyUpdateObject(Map<String, Object> updateData) {
        TypedMapWrapper<String, Object> typedMapWrapper = new TypedMapWrapper<String, Object>(updateData);
        this.applyUpdateObject(typedMapWrapper, null);
    }

    public void reEnableDependents(ExecutableNode ... nodes) {
        for (ExecutableNode node : nodes) {
            for (String dependent : node.getOutNodes()) {
                ExecutableNode dependentNode = this.getExecutableNode(dependent);
                if (dependentNode.getStatus() == Status.KILLED) {
                    dependentNode.setStatus(Status.READY);
                    dependentNode.setUpdateTime(System.currentTimeMillis());
                    this.reEnableDependents(dependentNode);
                    if (!(dependentNode instanceof ExecutableFlowBase)) continue;
                    ((ExecutableFlowBase)dependentNode).reEnableDependents(new ExecutableNode[0]);
                    continue;
                }
                if (dependentNode.getStatus() != Status.SKIPPED) continue;
                dependentNode.setStatus(Status.DISABLED);
                dependentNode.setUpdateTime(System.currentTimeMillis());
                this.reEnableDependents(dependentNode);
            }
        }
    }

    public String getFlowPath() {
        if (this.getParentFlow() == null) {
            return this.getFlowId();
        }
        return this.getParentFlow().getFlowPath() + "," + this.getId() + ":" + this.getFlowId();
    }
}

