/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionReference;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorApiClient;
import azkaban.executor.ExecutorManagerException;
import azkaban.utils.JSONUtils;
import azkaban.utils.Pair;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.codehaus.jackson.map.ObjectMapper;

@Singleton
public class ExecutorApiGateway {
    private final ExecutorApiClient apiClient;

    @Inject
    public ExecutorApiGateway(ExecutorApiClient apiClient) {
        this.apiClient = apiClient;
    }

    Map<String, Object> callWithExecutable(ExecutableFlow exflow, Executor executor, String action) throws ExecutorManagerException {
        return this.callWithExecutionId(executor.getHost(), executor.getPort(), action, exflow.getExecutionId(), null, null);
    }

    Map<String, Object> callWithReference(ExecutionReference ref, String action, Pair<String, String> ... params) throws ExecutorManagerException {
        Executor executor = ref.getExecutor().get();
        return this.callWithExecutionId(executor.getHost(), executor.getPort(), action, ref.getExecId(), null, params);
    }

    Map<String, Object> callWithReferenceByUser(ExecutionReference ref, String action, String user, Pair<String, String> ... params) throws ExecutorManagerException {
        Executor executor = ref.getExecutor().get();
        return this.callWithExecutionId(executor.getHost(), executor.getPort(), action, ref.getExecId(), user, params);
    }

    Map<String, Object> callWithExecutionId(String host, int port, String action, Integer executionId, String user, Pair<String, String> ... params) throws ExecutorManagerException {
        try {
            ArrayList<Pair<String, String>> paramList = new ArrayList<Pair<String, String>>();
            if (params != null) {
                paramList.addAll(Arrays.asList(params));
            }
            paramList.add(new Pair<String, String>("action", action));
            paramList.add(new Pair<String, String>("execid", String.valueOf(executionId)));
            paramList.add(new Pair<String, String>("user", user));
            return this.callForJsonObjectMap(host, port, "/executor", paramList);
        }
        catch (IOException e) {
            throw new ExecutorManagerException(e);
        }
    }

    <T> T callForJsonType(String host, int port, String path, List<Pair<String, String>> paramList, Class<T> valueType) throws IOException {
        String responseString = this.callForJsonString(host, port, path, paramList);
        if (null == responseString || responseString.length() == 0) {
            return null;
        }
        return (T)new ObjectMapper().readValue(responseString, valueType);
    }

    Map<String, Object> callForJsonObjectMap(String host, int port, String path, List<Pair<String, String>> paramList) throws IOException {
        String responseString = this.callForJsonString(host, port, path, paramList);
        Map jsonResponse = (Map)JSONUtils.parseJSONFromString((String)responseString);
        String error = (String)jsonResponse.get("error");
        if (error != null) {
            throw new IOException(error);
        }
        return jsonResponse;
    }

    private String callForJsonString(String host, int port, String path, List<Pair<String, String>> paramList) throws IOException {
        if (paramList == null) {
            paramList = new ArrayList<Pair<String, String>>();
        }
        URI uri = ExecutorApiClient.buildUri(host, port, path, true, new Pair[0]);
        return (String)this.apiClient.httpPost(uri, paramList);
    }
}

