/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.mail;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.executor.mail.MailCreator;
import azkaban.utils.EmailMessage;
import azkaban.utils.Utils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;

public class DefaultMailCreator
implements MailCreator {
    public static final String DEFAULT_MAIL_CREATOR = "default";
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
    private static final HashMap<String, MailCreator> registeredCreators = new HashMap();
    private static final MailCreator defaultCreator = new DefaultMailCreator();

    public static void registerCreator(String name, MailCreator creator) {
        registeredCreators.put(name, creator);
    }

    public static MailCreator getCreator(String name) {
        MailCreator creator = registeredCreators.get(name);
        if (creator == null) {
            creator = defaultCreator;
        }
        return creator;
    }

    private static String convertMSToString(long timeInMS) {
        if (timeInMS < 0L) {
            return "N/A";
        }
        return DATE_FORMATTER.format(new Date(timeInMS));
    }

    private static List<String> findFailedJobs(ExecutableFlow flow) {
        ArrayList<String> failedJobs = new ArrayList<String>();
        for (ExecutableNode node : flow.getExecutableNodes()) {
            if (node.getStatus() != Status.FAILED) continue;
            failedJobs.add(node.getId());
        }
        return failedJobs;
    }

    @Override
    public boolean createFirstErrorMessage(ExecutableFlow flow, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List<String> emailList = option.getFailureEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow '" + flow.getFlowId() + "' has encountered a failure on " + azkabanName);
            message.println("<h2 style=\"color:#FF0000\"> Execution '" + flow.getExecutionId() + "' of flow '" + flow.getFlowId() + "' of project '" + flow.getProjectName() + "' has encountered a failure on " + azkabanName + "</h2>");
            if (option.getFailureAction() == ExecutionOptions.FailureAction.CANCEL_ALL) {
                message.println("This flow is set to cancel all currently running jobs.");
            } else if (option.getFailureAction() == ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE) {
                message.println("This flow is set to complete all jobs that aren't blocked by the failure.");
            } else {
                message.println("This flow is set to complete all currently running jobs before stopping.");
            }
            message.println("<table>");
            message.println("<tr><td>Start Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getStartTime()) + "</td></tr>");
            message.println("<tr><td>End Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Duration</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Status</td><td>" + (Object)((Object)flow.getStatus()) + "</td></tr>");
            message.println("</table>");
            message.println("");
            String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
            message.println("<a href=\"" + executionUrl + "\">" + flow.getFlowId() + " Execution Link</a>");
            message.println("");
            message.println("<h3>Reason</h3>");
            List<String> failedJobs = DefaultMailCreator.findFailedJobs(flow);
            message.println("<ul>");
            for (String jobId : failedJobs) {
                message.println("<li><a href=\"" + executionUrl + "&job=" + jobId + "\">Failed job '" + jobId + "' Link</a></li>");
            }
            message.println("</ul>");
            return true;
        }
        return false;
    }

    @Override
    public boolean createErrorEmail(ExecutableFlow flow, List<ExecutableFlow> pastExecutions, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List<String> emailList = option.getFailureEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow '" + flow.getFlowId() + "' has failed on " + azkabanName);
            message.println("<h2 style=\"color:#FF0000\"> Execution '" + execId + "' of flow '" + flow.getFlowId() + "' of project '" + flow.getProjectName() + "' has failed on " + azkabanName + "</h2>");
            message.println("<table>");
            message.println("<tr><td>Start Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getStartTime()) + "</td></tr>");
            message.println("<tr><td>End Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Duration</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Status</td><td>" + (Object)((Object)flow.getStatus()) + "</td></tr>");
            message.println("</table>");
            message.println("");
            String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
            message.println("<a href=\"" + executionUrl + "\">" + flow.getFlowId() + " Execution Link</a>");
            message.println("");
            message.println("<h3>Reason</h3>");
            List<String> failedJobs = DefaultMailCreator.findFailedJobs(flow);
            message.println("<ul>");
            for (String jobId : failedJobs) {
                message.println("<li><a href=\"" + executionUrl + "&job=" + jobId + "\">Failed job '" + jobId + "' Link</a></li>");
            }
            for (String reasons : vars) {
                message.println("<li>" + reasons + "</li>");
            }
            message.println("</ul>");
            message.println("");
            int failedCount = 0;
            for (ExecutableFlow executableFlow : pastExecutions) {
                if (!executableFlow.getStatus().equals((Object)Status.FAILED)) continue;
                ++failedCount;
            }
            message.println(String.format("<h3>Executions from past 72 hours (%s out %s) failed</h3>", failedCount, pastExecutions.size()));
            for (ExecutableFlow executableFlow : pastExecutions) {
                message.println("<table>");
                message.println("<tr><td>Execution Id</td><td>" + executableFlow.getExecutionId() + "</td></tr>");
                message.println("<tr><td>Start Time</td><td>" + DefaultMailCreator.convertMSToString(executableFlow.getStartTime()) + "</td></tr>");
                message.println("<tr><td>End Time</td><td>" + DefaultMailCreator.convertMSToString(executableFlow.getEndTime()) + "</td></tr>");
                message.println("<tr><td>Status</td><td>" + (Object)((Object)executableFlow.getStatus()) + "</td></tr>");
                message.println("</table>");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean createSuccessEmail(ExecutableFlow flow, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List<String> emailList = option.getSuccessEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow '" + flow.getFlowId() + "' has succeeded on " + azkabanName);
            message.println("<h2> Execution '" + flow.getExecutionId() + "' of flow '" + flow.getFlowId() + "' of project '" + flow.getProjectName() + "' has succeeded on " + azkabanName + "</h2>");
            message.println("<table>");
            message.println("<tr><td>Start Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getStartTime()) + "</td></tr>");
            message.println("<tr><td>End Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Duration</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Status</td><td>" + (Object)((Object)flow.getStatus()) + "</td></tr>");
            message.println("</table>");
            message.println("");
            String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
            message.println("<a href=\"" + executionUrl + "\">" + flow.getFlowId() + " Execution Link</a>");
            return true;
        }
        return false;
    }

    @Override
    public boolean createFailedUpdateMessage(List<ExecutableFlow> flows, Executor executor, ExecutorManagerException updateException, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber) {
        ExecutionOptions option = flows.get(0).getExecutionOptions();
        List<String> emailList = option.getFailureEmails();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow status could not be updated from " + executor.getHost() + " on " + azkabanName);
            message.println("<h2 style=\"color:#FF0000\"> Flow status could not be updated from " + executor.getHost() + " on " + azkabanName + "</h2>");
            message.println("The actual status of these executions is unknown, because getting status update from azkaban executor is failing");
            message.println("");
            message.println("<h3>Error detail</h3>");
            message.println("<pre>" + ExceptionUtils.getStackTrace((Throwable)updateException) + "</pre>");
            message.println("");
            message.println("<h3>Affected executions</h3>");
            message.println("<ul>");
            for (ExecutableFlow flow : flows) {
                int execId = flow.getExecutionId();
                String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
                message.println("<li>Execution '" + flow.getExecutionId() + "' of flow '" + flow.getFlowId() + "' of project '" + flow.getProjectName() + "' -  <a href=\"" + executionUrl + "\">Execution Link</a></li>");
            }
            message.println("</ul>");
            return true;
        }
        return false;
    }

    static {
        DefaultMailCreator.registerCreator(DEFAULT_MAIL_CREATOR, defaultCreator);
    }
}

