/*
 * Decompiled with CFR 0.152.
 */
package azkaban.flow;

import azkaban.flow.ConditionOnJobStatus;
import azkaban.utils.Utils;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class Node {
    private final String id;
    private String jobSource;
    private String propsSource;
    private Point2D position = null;
    private int level;
    private int expectedRunTimeSec = 1;
    private String type;
    private String embeddedFlowId;
    private String condition = null;
    private ConditionOnJobStatus conditionOnJobStatus = ConditionOnJobStatus.ALL_SUCCESS;

    public Node(String id) {
        this.id = id;
    }

    public Node(Node clone) {
        this.id = clone.id;
        this.propsSource = clone.propsSource;
        this.jobSource = clone.jobSource;
    }

    public static Node fromObject(Object obj) {
        Map layoutInfo;
        Map mapObj = (Map)obj;
        String id = (String)mapObj.get("id");
        Node node = new Node(id);
        String jobSource = (String)mapObj.get("jobSource");
        String propSource = (String)mapObj.get("propSource");
        String jobType = (String)mapObj.get("jobType");
        String embeddedFlowId = (String)mapObj.get("embeddedFlowId");
        String condition = (String)mapObj.get("condition");
        node.setJobSource(jobSource);
        node.setPropsSource(propSource);
        node.setType(jobType);
        node.setEmbeddedFlowId(embeddedFlowId);
        node.setCondition(condition);
        Integer expectedRuntime = (Integer)mapObj.get("expectedRuntime");
        if (expectedRuntime != null) {
            node.setExpectedRuntimeSec(expectedRuntime);
        }
        if ((layoutInfo = (Map)mapObj.get("layout")) != null) {
            Double x = null;
            Double y = null;
            Integer level = null;
            try {
                x = Utils.convertToDouble(layoutInfo.get("x"));
                y = Utils.convertToDouble(layoutInfo.get("y"));
                level = (Integer)layoutInfo.get("level");
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Error creating node " + id, e);
            }
            if (x != null && y != null) {
                node.setPosition(new Point2D.Double(x, y));
            }
            if (level != null) {
                node.setLevel(level);
            }
        }
        return node;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void setPosition(double x, double y) {
        this.position = new Point2D.Double(x, y);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getJobSource() {
        return this.jobSource;
    }

    public void setJobSource(String jobSource) {
        this.jobSource = jobSource;
    }

    public String getPropsSource() {
        return this.propsSource;
    }

    public void setPropsSource(String propsSource) {
        this.propsSource = propsSource;
    }

    public int getExpectedRuntimeSec() {
        return this.expectedRunTimeSec;
    }

    public void setExpectedRuntimeSec(int runtimeSec) {
        this.expectedRunTimeSec = runtimeSec;
    }

    public String getEmbeddedFlowId() {
        return this.embeddedFlowId;
    }

    public void setEmbeddedFlowId(String flowId) {
        this.embeddedFlowId = flowId;
    }

    public Object toObject() {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        objMap.put("id", this.id);
        objMap.put("jobSource", this.jobSource);
        objMap.put("propSource", this.propsSource);
        objMap.put("jobType", this.type);
        if (this.embeddedFlowId != null) {
            objMap.put("embeddedFlowId", this.embeddedFlowId);
        }
        objMap.put("expectedRuntime", this.expectedRunTimeSec);
        HashMap<String, Number> layoutInfo = new HashMap<String, Number>();
        if (this.position != null) {
            layoutInfo.put("x", this.position.getX());
            layoutInfo.put("y", this.position.getY());
        }
        layoutInfo.put("level", this.level);
        objMap.put("layout", layoutInfo);
        objMap.put("condition", this.condition);
        return objMap;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public ConditionOnJobStatus getConditionOnJobStatus() {
        return this.conditionOnJobStatus;
    }

    public void setConditionOnJobStatus(ConditionOnJobStatus conditionOnJobStatus) {
        this.conditionOnJobStatus = conditionOnJobStatus;
    }
}

