/*
 * Decompiled with CFR 0.152.
 */
package azkaban.metrics;

import azkaban.metrics.MetricsManager;
import com.codahale.metrics.Meter;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CommonMetrics {
    private final AtomicLong OOMWaitingJobCount = new AtomicLong(0L);
    private final MetricsManager metricsManager;
    private Meter flowFailMeter;
    private Meter dispatchFailMeter;
    private Meter dispatchSuccessMeter;
    private Meter sendEmailFailMeter;
    private Meter sendEmailSuccessMeter;

    @Inject
    public CommonMetrics(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
        this.setupAllMetrics();
    }

    private void setupAllMetrics() {
        this.flowFailMeter = this.metricsManager.addMeter("flow-fail-meter");
        this.dispatchFailMeter = this.metricsManager.addMeter("dispatch-fail-meter");
        this.dispatchSuccessMeter = this.metricsManager.addMeter("dispatch-success-meter");
        this.sendEmailFailMeter = this.metricsManager.addMeter("send-email-fail-meter");
        this.sendEmailSuccessMeter = this.metricsManager.addMeter("send-email-success-meter");
        this.metricsManager.addGauge("OOM-waiting-job-count", this.OOMWaitingJobCount::get);
    }

    public void markFlowFail() {
        this.flowFailMeter.mark();
    }

    public void markDispatchFail() {
        this.dispatchFailMeter.mark();
    }

    public void markDispatchSuccess() {
        this.dispatchSuccessMeter.mark();
    }

    public void markSendEmailFail() {
        this.sendEmailFailMeter.mark();
    }

    public void markSendEmailSuccess() {
        this.sendEmailSuccessMeter.mark();
    }

    public void incrementOOMJobWaitCount() {
        this.OOMWaitingJobCount.incrementAndGet();
    }

    public void decrementOOMJobWaitCount() {
        this.OOMWaitingJobCount.decrementAndGet();
    }
}

