/*
 * Decompiled with CFR 0.152.
 */
package azkaban.storage;

import azkaban.db.DatabaseOperator;
import azkaban.spi.Storage;
import azkaban.utils.Props;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;

@Singleton
public class StorageCleaner {
    static final String SQL_DELETE_RESOURCE_ID = "DELETE FROM project_versions WHERE resource_id=?";
    static final String SQL_FETCH_PVR = "SELECT resource_id FROM project_versions WHERE project_id=? AND resource_id IS NOT NULL ORDER BY version DESC";
    private static final Logger log = Logger.getLogger(StorageCleaner.class);
    private final DatabaseOperator databaseOperator;
    private final int maxArtifactsPerProject;
    private final Storage storage;

    @Inject
    public StorageCleaner(Props props, Storage storage, DatabaseOperator databaseOperator) {
        this.storage = storage;
        this.databaseOperator = databaseOperator;
        this.maxArtifactsPerProject = props.getInt("azkaban.storage.artifact.max.retention", 0);
        Preconditions.checkArgument((this.maxArtifactsPerProject >= 0 ? 1 : 0) != 0, (Object)String.format("Invalid value for %s : %d", "azkaban.storage.artifact.max.retention", this.maxArtifactsPerProject));
        if (this.isCleanupPermitted()) {
            log.info((Object)String.format("%s Config: Max %d artifact(s) retained per project", "azkaban.storage.artifact.max.retention", this.maxArtifactsPerProject));
        } else {
            log.warn((Object)"Project cleanup disabled. All artifacts will be stored.");
        }
    }

    @VisibleForTesting
    boolean isCleanupPermitted() {
        return this.maxArtifactsPerProject > 0;
    }

    public void cleanupProjectArtifacts(int projectId) {
        if (!this.isCleanupPermitted()) {
            return;
        }
        Set<String> allResourceIds = this.findResourceIdsToDelete(projectId);
        if (allResourceIds.size() == 0) {
            return;
        }
        log.warn((Object)String.format("Deleting project artifacts [id: %d]: %s", projectId, allResourceIds));
        allResourceIds.forEach(this::delete);
    }

    private Set<String> findResourceIdsToDelete(int projectId) {
        List<String> resourceIdOrderedList = this.fetchResourceIdOrderedList(projectId);
        if (resourceIdOrderedList.size() <= this.maxArtifactsPerProject) {
            return Collections.emptySet();
        }
        HashSet<String> allResourceIds = new HashSet<String>(resourceIdOrderedList);
        HashSet<String> doNotDeleteSet = new HashSet<String>(resourceIdOrderedList.subList(0, this.maxArtifactsPerProject));
        allResourceIds.removeAll(doNotDeleteSet);
        return allResourceIds;
    }

    private boolean delete(String resourceId) {
        boolean isDeleted;
        boolean bl = isDeleted = this.storage.delete(resourceId) && this.removeDbEntry(resourceId);
        if (!isDeleted) {
            log.info((Object)("Failed to delete resourceId: " + resourceId));
        }
        return isDeleted;
    }

    private boolean removeDbEntry(String resourceId) {
        try {
            int nAffectedRows = this.databaseOperator.update(SQL_DELETE_RESOURCE_ID, new Object[]{resourceId});
            return nAffectedRows > 0;
        }
        catch (SQLException e) {
            log.error((Object)("Error while deleting DB metadata resource ID: " + resourceId), (Throwable)e);
            return false;
        }
    }

    private List<String> fetchResourceIdOrderedList(int projectId) {
        try {
            return (List)this.databaseOperator.query(SQL_FETCH_PVR, rs -> {
                ArrayList<String> results = new ArrayList<String>();
                while (rs.next()) {
                    results.add(rs.getString(1));
                }
                return results;
            }, new Object[]{projectId});
        }
        catch (SQLException e) {
            log.error((Object)("Error performing cleanup of Project: " + projectId), (Throwable)e);
            return Collections.emptyList();
        }
    }
}

