/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.event.EventHandler;
import azkaban.executor.ExecutorManager;
import azkaban.trigger.ActionTypeLoader;
import azkaban.trigger.CheckerTypeLoader;
import azkaban.trigger.Condition;
import azkaban.trigger.ConditionChecker;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerLoader;
import azkaban.trigger.TriggerLoaderException;
import azkaban.trigger.TriggerManagerAdapter;
import azkaban.trigger.TriggerManagerException;
import azkaban.trigger.TriggerStatus;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;

@Singleton
public class TriggerManager
extends EventHandler
implements TriggerManagerAdapter {
    public static final long DEFAULT_SCANNER_INTERVAL_MS = 60000L;
    private static final Logger logger = Logger.getLogger(TriggerManager.class);
    private static final Map<Integer, Trigger> triggerIdMap = new ConcurrentHashMap<Integer, Trigger>();
    private final TriggerScannerThread runnerThread;
    private final Object syncObj = new Object();
    private final CheckerTypeLoader checkerTypeLoader;
    private final ActionTypeLoader actionTypeLoader;
    private final TriggerLoader triggerLoader;
    private final LocalTriggerJMX jmxStats = new LocalTriggerJMX();
    private long lastRunnerThreadCheckTime = -1L;
    private long runnerThreadIdleTime = -1L;
    private String scannerStage = "";

    @Inject
    public TriggerManager(Props props, TriggerLoader triggerLoader, ExecutorManager executorManager) throws TriggerManagerException {
        Objects.requireNonNull(props);
        Objects.requireNonNull(executorManager);
        this.triggerLoader = Objects.requireNonNull(triggerLoader);
        long scannerInterval = props.getLong("trigger.scan.interval", 60000L);
        this.runnerThread = new TriggerScannerThread(scannerInterval);
        this.checkerTypeLoader = new CheckerTypeLoader();
        this.actionTypeLoader = new ActionTypeLoader();
        try {
            this.checkerTypeLoader.init(props);
            this.actionTypeLoader.init(props);
        }
        catch (Exception e) {
            throw new TriggerManagerException(e);
        }
        Condition.setCheckerLoader(this.checkerTypeLoader);
        Trigger.setActionTypeLoader(this.actionTypeLoader);
        logger.info((Object)"TriggerManager loaded.");
    }

    @Override
    public void start() throws TriggerManagerException {
        try {
            List<Trigger> triggers = this.triggerLoader.loadTriggers();
            for (Trigger t : triggers) {
                this.runnerThread.addTrigger(t);
                triggerIdMap.put(t.getTriggerId(), t);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TriggerManagerException(e);
        }
        this.runnerThread.start();
    }

    protected CheckerTypeLoader getCheckerLoader() {
        return this.checkerTypeLoader;
    }

    protected ActionTypeLoader getActionLoader() {
        return this.actionTypeLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTrigger(Trigger t) throws TriggerManagerException {
        logger.info((Object)("Inserting trigger " + t + " in TriggerManager"));
        Object object = this.syncObj;
        synchronized (object) {
            try {
                this.triggerLoader.addTrigger(t);
            }
            catch (TriggerLoaderException e) {
                throw new TriggerManagerException(e);
            }
            this.runnerThread.addTrigger(t);
            triggerIdMap.put(t.getTriggerId(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrigger(int id) throws TriggerManagerException {
        logger.info((Object)("Removing trigger with id: " + id + " from TriggerManager"));
        Object object = this.syncObj;
        synchronized (object) {
            Trigger t = triggerIdMap.get(id);
            if (t != null) {
                this.removeTrigger(triggerIdMap.get(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrigger(Trigger t) throws TriggerManagerException {
        logger.info((Object)("Updating trigger " + t + " in TriggerManager"));
        Object object = this.syncObj;
        synchronized (object) {
            this.runnerThread.deleteTrigger(triggerIdMap.get(t.getTriggerId()));
            this.runnerThread.addTrigger(t);
            triggerIdMap.put(t.getTriggerId(), t);
            try {
                this.triggerLoader.updateTrigger(t);
            }
            catch (TriggerLoaderException e) {
                throw new TriggerManagerException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrigger(Trigger t) throws TriggerManagerException {
        logger.info((Object)("Removing trigger " + t + " from TriggerManager"));
        Object object = this.syncObj;
        synchronized (object) {
            this.runnerThread.deleteTrigger(t);
            triggerIdMap.remove(t.getTriggerId());
            try {
                t.stopCheckers();
                this.triggerLoader.removeTrigger(t);
            }
            catch (TriggerLoaderException e) {
                throw new TriggerManagerException(e);
            }
        }
    }

    public List<Trigger> getTriggers() {
        return new ArrayList<Trigger>(triggerIdMap.values());
    }

    public Map<String, Class<? extends ConditionChecker>> getSupportedCheckers() {
        return this.checkerTypeLoader.getSupportedCheckers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger getTrigger(int triggerId) {
        Object object = this.syncObj;
        synchronized (object) {
            return triggerIdMap.get(triggerId);
        }
    }

    public void expireTrigger(int triggerId) {
        Trigger t = this.getTrigger(triggerId);
        t.setStatus(TriggerStatus.EXPIRED);
    }

    @Override
    public List<Trigger> getTriggers(String triggerSource) {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (Trigger t : triggerIdMap.values()) {
            if (!t.getSource().equals(triggerSource)) continue;
            triggers.add(t);
        }
        return triggers;
    }

    @Override
    public List<Trigger> getTriggerUpdates(String triggerSource, long lastUpdateTime) throws TriggerManagerException {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (Trigger t : triggerIdMap.values()) {
            if (!t.getSource().equals(triggerSource) || t.getLastModifyTime() <= lastUpdateTime) continue;
            triggers.add(t);
        }
        return triggers;
    }

    @Override
    public List<Trigger> getAllTriggerUpdates(long lastUpdateTime) throws TriggerManagerException {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (Trigger t : triggerIdMap.values()) {
            if (t.getLastModifyTime() <= lastUpdateTime) continue;
            triggers.add(t);
        }
        return triggers;
    }

    @Override
    public void insertTrigger(Trigger t, String user) throws TriggerManagerException {
        this.insertTrigger(t);
    }

    @Override
    public void removeTrigger(int id, String user) throws TriggerManagerException {
        this.removeTrigger(id);
    }

    @Override
    public void updateTrigger(Trigger t, String user) throws TriggerManagerException {
        this.updateTrigger(t);
    }

    @Override
    public void shutdown() {
        this.runnerThread.shutdown();
    }

    @Override
    public TriggerManagerAdapter.TriggerJMX getJMX() {
        return this.jmxStats;
    }

    @Override
    public void registerCheckerType(String name, Class<? extends ConditionChecker> checker) {
        this.checkerTypeLoader.registerCheckerType(name, checker);
    }

    @Override
    public void registerActionType(String name, Class<? extends TriggerAction> action) {
        this.actionTypeLoader.registerActionType(name, action);
    }

    private class LocalTriggerJMX
    implements TriggerManagerAdapter.TriggerJMX {
        private LocalTriggerJMX() {
        }

        @Override
        public long getLastRunnerThreadCheckTime() {
            return TriggerManager.this.lastRunnerThreadCheckTime;
        }

        @Override
        public boolean isRunnerThreadActive() {
            return TriggerManager.this.runnerThread.isAlive();
        }

        @Override
        public String getPrimaryServerHost() {
            return "local";
        }

        @Override
        public int getNumTriggers() {
            return triggerIdMap.size();
        }

        @Override
        public String getTriggerSources() {
            HashSet<String> sources = new HashSet<String>();
            for (Trigger t : triggerIdMap.values()) {
                sources.add(t.getSource());
            }
            return ((Object)sources).toString();
        }

        @Override
        public String getTriggerIds() {
            return triggerIdMap.keySet().toString();
        }

        @Override
        public long getScannerIdleTime() {
            return TriggerManager.this.runnerThreadIdleTime;
        }

        @Override
        public Map<String, Object> getAllJMXMbeans() {
            return new HashMap<String, Object>();
        }

        @Override
        public String getScannerThreadStage() {
            return TriggerManager.this.scannerStage;
        }
    }

    private class TriggerScannerThread
    extends Thread {
        private final long scannerInterval;
        private final BlockingQueue<Trigger> triggers = new PriorityBlockingQueue<Trigger>(1, new TriggerComparator());
        private boolean shutdown = false;

        public TriggerScannerThread(long scannerInterval) {
            this.setName("TriggerRunnerManager-Trigger-Scanner-Thread");
            this.scannerInterval = scannerInterval;
        }

        public void shutdown() {
            logger.error((Object)("Shutting down trigger manager thread " + this.getName()));
            this.shutdown = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTrigger(Trigger t) {
            Object object = TriggerManager.this.syncObj;
            synchronized (object) {
                t.updateNextCheckTime();
                this.triggers.add(t);
            }
        }

        public void deleteTrigger(Trigger t) {
            this.triggers.remove(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                Object object = TriggerManager.this.syncObj;
                synchronized (object) {
                    try {
                        TriggerManager.this.lastRunnerThreadCheckTime = System.currentTimeMillis();
                        TriggerManager.this.scannerStage = "Ready to start a new scan cycle at " + TriggerManager.this.lastRunnerThreadCheckTime;
                        try {
                            this.checkAllTriggers();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error((Object)e.getMessage());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            logger.error((Object)t.getMessage());
                        }
                        TriggerManager.this.scannerStage = "Done flipping all triggers.";
                        TriggerManager.this.runnerThreadIdleTime = this.scannerInterval - (System.currentTimeMillis() - TriggerManager.this.lastRunnerThreadCheckTime);
                        if (TriggerManager.this.runnerThreadIdleTime < 0L) {
                            logger.error((Object)("Trigger manager thread " + this.getName() + " is too busy!"));
                        } else {
                            TriggerManager.this.syncObj.wait(TriggerManager.this.runnerThreadIdleTime);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.info((Object)"Interrupted. Probably to shut down.");
                    }
                }
            }
        }

        private void checkAllTriggers() throws TriggerManagerException {
            for (Trigger t : this.triggers) {
                try {
                    TriggerManager.this.scannerStage = "Checking for trigger " + t.getTriggerId();
                    if (t.getStatus().equals((Object)TriggerStatus.READY)) {
                        if (t.getExpireCondition().getExpression().contains("EndTimeChecker") && t.expireConditionMet()) {
                            this.onTriggerPause(t);
                        } else if (t.triggerConditionMet()) {
                            this.onTriggerTrigger(t);
                        }
                    }
                    if (t.getStatus().equals((Object)TriggerStatus.EXPIRED) && t.getSource().equals("azkaban")) {
                        TriggerManager.this.removeTrigger(t);
                        continue;
                    }
                    t.updateNextCheckTime();
                }
                catch (Throwable th) {
                    logger.error((Object)("Failed to process trigger with id : " + t), th);
                }
            }
        }

        private void onTriggerTrigger(Trigger t) throws TriggerManagerException {
            List<TriggerAction> actions = t.getTriggerActions();
            for (TriggerAction action : actions) {
                try {
                    logger.info((Object)("Doing trigger actions " + action.getDescription() + " for " + t));
                    action.doAction();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to do action " + action.getDescription() + " for " + t), (Throwable)e);
                }
                catch (Throwable th) {
                    logger.error((Object)("Failed to do action " + action.getDescription() + " for " + t), th);
                }
            }
            if (t.isResetOnTrigger()) {
                t.resetTriggerConditions();
            } else {
                logger.info((Object)("NextCheckTime did not change. Setting status to expired for trigger" + t.getTriggerId()));
                t.setStatus(TriggerStatus.EXPIRED);
            }
            try {
                TriggerManager.this.triggerLoader.updateTrigger(t);
            }
            catch (TriggerLoaderException e) {
                throw new TriggerManagerException(e);
            }
        }

        private void onTriggerPause(Trigger t) throws TriggerManagerException {
            List<TriggerAction> expireActions = t.getExpireActions();
            for (TriggerAction action : expireActions) {
                try {
                    logger.info((Object)("Doing expire actions for " + action.getDescription() + " for " + t));
                    action.doAction();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to do expire action " + action.getDescription() + " for " + t), (Throwable)e);
                }
                catch (Throwable th) {
                    logger.error((Object)("Failed to do expire action " + action.getDescription() + " for " + t), th);
                }
            }
            logger.info((Object)("Pausing Trigger " + t.getDescription()));
            t.setStatus(TriggerStatus.PAUSED);
            try {
                TriggerManager.this.triggerLoader.updateTrigger(t);
            }
            catch (TriggerLoaderException e) {
                throw new TriggerManagerException(e);
            }
        }

        private class TriggerComparator
        implements Comparator<Trigger> {
            private TriggerComparator() {
            }

            @Override
            public int compare(Trigger arg0, Trigger arg1) {
                long second;
                long first = arg1.getNextCheckTime();
                if (first == (second = arg0.getNextCheckTime())) {
                    return 0;
                }
                if (first < second) {
                    return 1;
                }
                return -1;
            }
        }
    }
}

