/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.trigger.ConditionChecker;
import azkaban.utils.Utils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;
import org.quartz.CronExpression;

public class BasicTimeChecker
implements ConditionChecker {
    public static final String type = "BasicTimeChecker";
    private final String id;
    private final long firstCheckTime;
    private final DateTimeZone timezone;
    private final ReadablePeriod period;
    private final String cronExpression;
    private final CronExpression cronExecutionTime;
    private long nextCheckTime;
    private boolean isRecurring = true;
    private boolean skipPastChecks = true;

    public BasicTimeChecker(String id, long firstCheckTime, DateTimeZone timezone, boolean isRecurring, boolean skipPastChecks, ReadablePeriod period, String cronExpression) {
        this.id = id;
        this.firstCheckTime = firstCheckTime;
        this.timezone = timezone;
        this.isRecurring = isRecurring;
        this.skipPastChecks = skipPastChecks;
        this.period = period;
        this.nextCheckTime = firstCheckTime;
        this.cronExpression = cronExpression;
        this.cronExecutionTime = Utils.parseCronExpression((String)cronExpression, (DateTimeZone)timezone);
        this.nextCheckTime = this.calculateNextCheckTime();
    }

    public BasicTimeChecker(String id, long firstCheckTime, DateTimeZone timezone, long nextCheckTime, boolean isRecurring, boolean skipPastChecks, ReadablePeriod period, String cronExpression) {
        this.id = id;
        this.firstCheckTime = firstCheckTime;
        this.timezone = timezone;
        this.nextCheckTime = nextCheckTime;
        this.isRecurring = isRecurring;
        this.skipPastChecks = skipPastChecks;
        this.period = period;
        this.cronExpression = cronExpression;
        this.cronExecutionTime = Utils.parseCronExpression((String)cronExpression, (DateTimeZone)timezone);
    }

    public static BasicTimeChecker createFromJson(Object obj) throws Exception {
        return BasicTimeChecker.createFromJson((HashMap)obj);
    }

    public static BasicTimeChecker createFromJson(HashMap<String, Object> obj) throws Exception {
        HashMap<String, Object> jsonObj = obj;
        if (!jsonObj.get("type").equals(type)) {
            throw new Exception("Cannot create checker of BasicTimeChecker from " + jsonObj.get("type"));
        }
        Long firstCheckTime = Long.valueOf((String)jsonObj.get("firstCheckTime"));
        String timezoneId = (String)jsonObj.get("timezone");
        long nextCheckTime = Long.valueOf((String)jsonObj.get("nextCheckTime"));
        DateTimeZone timezone = DateTimeZone.forID((String)timezoneId);
        boolean isRecurring = Boolean.valueOf((String)jsonObj.get("isRecurring"));
        boolean skipPastChecks = Boolean.valueOf((String)jsonObj.get("skipPastChecks"));
        ReadablePeriod period = Utils.parsePeriodString((String)((String)jsonObj.get("period")));
        String id = (String)jsonObj.get("id");
        String cronExpression = (String)jsonObj.get("cronExpression");
        BasicTimeChecker checker = new BasicTimeChecker(id, firstCheckTime, timezone, nextCheckTime, isRecurring, skipPastChecks, period, cronExpression);
        if (skipPastChecks) {
            checker.updateNextCheckTime();
        }
        return checker;
    }

    public long getFirstCheckTime() {
        return this.firstCheckTime;
    }

    public DateTimeZone getTimeZone() {
        return this.timezone;
    }

    public boolean isRecurring() {
        return this.isRecurring;
    }

    public boolean isSkipPastChecks() {
        return this.skipPastChecks;
    }

    public ReadablePeriod getPeriod() {
        return this.period;
    }

    @Override
    public long getNextCheckTime() {
        return this.nextCheckTime;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    @Override
    public Boolean eval() {
        return this.nextCheckTime < DateTimeUtils.currentTimeMillis();
    }

    @Override
    public void reset() {
        this.nextCheckTime = this.calculateNextCheckTime();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public BasicTimeChecker fromJson(Object obj) throws Exception {
        return BasicTimeChecker.createFromJson(obj);
    }

    private void updateNextCheckTime() {
        this.nextCheckTime = this.calculateNextCheckTime();
    }

    private long calculateNextCheckTime() {
        DateTime date = new DateTime(this.nextCheckTime).withZone(this.timezone);
        int count = 0;
        while (!date.isAfterNow()) {
            if (count > 100000) {
                throw new IllegalStateException("100000 increments of period did not get to present time.");
            }
            if (this.period == null && this.cronExpression == null) break;
            if (this.cronExecutionTime != null) {
                Date nextDate = this.cronExecutionTime.getNextValidTimeAfter(date.toDate());
                if (nextDate == null) break;
                date = new DateTime((Object)nextDate);
            } else {
                date = date.plus(this.period);
            }
            ++count;
        }
        return date.getMillis();
    }

    @Override
    public Object getNum() {
        return null;
    }

    @Override
    public Object toJson() {
        HashMap<String, String> jsonObj = new HashMap<String, String>();
        jsonObj.put("type", type);
        jsonObj.put("firstCheckTime", String.valueOf(this.firstCheckTime));
        jsonObj.put("timezone", this.timezone.getID());
        jsonObj.put("nextCheckTime", String.valueOf(this.nextCheckTime));
        jsonObj.put("isRecurring", String.valueOf(this.isRecurring));
        jsonObj.put("skipPastChecks", String.valueOf(this.skipPastChecks));
        jsonObj.put("period", Utils.createPeriodString((ReadablePeriod)this.period));
        jsonObj.put("id", this.id);
        jsonObj.put("cronExpression", this.cronExpression);
        return jsonObj;
    }

    @Override
    public void stopChecker() {
    }

    @Override
    public void setContext(Map<String, Object> context) {
    }
}

