/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline.extended;

import com.android.dx.mockito.inline.InlineDexmakerMockMaker;
import com.android.dx.mockito.inline.InlineStaticMockMaker;
import com.android.dx.mockito.inline.extended.MockedMethod;
import com.android.dx.mockito.inline.extended.MockedVoidMethod;
import com.android.dx.mockito.inline.extended.StaticCapableStubber;
import com.android.dx.mockito.inline.extended.StaticInOrder;
import com.android.dx.mockito.inline.extended.StaticMockitoSession;
import com.android.dx.mockito.inline.extended.StaticMockitoSessionBuilder;
import com.android.dx.mockito.inline.extended.UnstableApi;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.internal.matchers.LocalizedMatcher;
import org.mockito.internal.progress.ArgumentMatcherStorageImpl;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@UnstableApi
public class ExtendedMockito
extends Mockito {
    private static ArrayList<StaticMockitoSession> sessions = new ArrayList();

    public static StaticCapableStubber doAnswer(Answer answer) {
        return new StaticCapableStubber(Mockito.doAnswer((Answer)answer));
    }

    public static StaticCapableStubber doCallRealMethod() {
        return new StaticCapableStubber(Mockito.doCallRealMethod());
    }

    public static StaticCapableStubber doNothing() {
        return new StaticCapableStubber(Mockito.doNothing());
    }

    public static StaticCapableStubber doReturn(Object toBeReturned) {
        return new StaticCapableStubber(Mockito.doReturn((Object)toBeReturned));
    }

    public static StaticCapableStubber doReturn(Object toBeReturned, Object ... toBeReturnedNext) {
        return new StaticCapableStubber(Mockito.doReturn((Object)toBeReturned, (Object[])toBeReturnedNext));
    }

    public static StaticCapableStubber doThrow(Class<? extends Throwable> toBeThrown) {
        return new StaticCapableStubber(Mockito.doThrow(toBeThrown));
    }

    @SafeVarargs
    public static StaticCapableStubber doThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... toBeThrownNext) {
        return new StaticCapableStubber(Mockito.doThrow(toBeThrown, (Class[])toBeThrownNext));
    }

    public static StaticCapableStubber doThrow(Throwable ... toBeThrown) {
        return new StaticCapableStubber(Mockito.doThrow((Throwable[])toBeThrown));
    }

    @UnstableApi
    public static <T> T staticMockMarker(Class<T> clazz) {
        for (StaticMockitoSession session : sessions) {
            T marker = session.staticMockMarker(clazz);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    @UnstableApi
    public static Object[] staticMockMarker(Class<?> ... clazz) {
        Object[] markers = new Object[clazz.length];
        for (int i = 0; i < clazz.length; ++i) {
            for (StaticMockitoSession session : sessions) {
                markers[i] = session.staticMockMarker(clazz[i]);
                if (markers[i] == null) continue;
                break;
            }
            if (markers[i] != null) continue;
            return null;
        }
        return markers;
    }

    @UnstableApi
    public static void spyOn(Object toSpy) {
        if (InlineDexmakerMockMaker.onSpyInProgressInstance.get() != null) {
            throw new IllegalStateException("Cannot set up spying on an existing object while setting up spying for another existing object");
        }
        InlineDexmakerMockMaker.onSpyInProgressInstance.set(toSpy);
        try {
            ExtendedMockito.spy((Object)toSpy);
        }
        finally {
            InlineDexmakerMockMaker.onSpyInProgressInstance.remove();
        }
    }

    public static void verify(MockedVoidMethod method) {
        ExtendedMockito.verify(method, ExtendedMockito.times((int)1));
    }

    @UnstableApi
    public static void verify(MockedMethod method) {
        ExtendedMockito.verify(method, ExtendedMockito.times((int)1));
    }

    @UnstableApi
    public static void verify(MockedVoidMethod method, VerificationMode mode) {
        ExtendedMockito.verifyInt(method, mode, null);
    }

    @UnstableApi
    public static void verify(MockedMethod method, VerificationMode mode) {
        ExtendedMockito.verify(method::get, mode);
    }

    @UnstableApi
    public static StaticInOrder inOrder(Object ... mocksAndMarkers) {
        return new StaticInOrder(Mockito.inOrder((Object[])mocksAndMarkers));
    }

    public static StaticMockitoSessionBuilder mockitoSession() {
        return new StaticMockitoSessionBuilder(Mockito.mockitoSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void verifyInt(MockedVoidMethod method, VerificationMode mode, InOrder instanceInOrder) {
        if (InlineStaticMockMaker.onMethodCallDuringVerification.get() != null) {
            throw new IllegalStateException("Verification is already in progress on this thread.");
        }
        ArrayList verifications = new ArrayList();
        InlineStaticMockMaker.onMethodCallDuringVerification.set((clazz, verifiedMethod) -> {
            try {
                ArgumentMatcherStorageImpl argMatcherStorage = (ArgumentMatcherStorageImpl)ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage();
                Method resetStackMethod = argMatcherStorage.getClass().getDeclaredMethod("resetStack", new Class[0]);
                resetStackMethod.setAccessible(true);
                List matchers = (List)resetStackMethod.invoke((Object)argMatcherStorage, new Object[0]);
                if (instanceInOrder == null) {
                    ExtendedMockito.verify(ExtendedMockito.staticMockMarker(clazz), (VerificationMode)mode);
                } else {
                    instanceInOrder.verify(ExtendedMockito.staticMockMarker(clazz), mode);
                }
                Field matcherStackField = argMatcherStorage.getClass().getDeclaredField("matcherStack");
                matcherStackField.setAccessible(true);
                Method pushMethod = matcherStackField.getType().getDeclaredMethod("push", Object.class);
                for (LocalizedMatcher matcher : matchers) {
                    pushMethod.invoke(matcherStackField.get(argMatcherStorage), matcher);
                }
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                throw new Error("Reflection failed. Do you use a compatible version of mockito?", e);
            }
            verifications.add(verifiedMethod);
        });
        try {
            try {
                method.run();
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            if (verifications.isEmpty()) {
                throw new IllegalArgumentException("Nothing was verified. Does the lambda call a static method on a 'static' mock/spy ?");
            }
            if (verifications.size() > 1) {
                throw new IllegalArgumentException("Multiple intercepted calls on methods " + verifications);
            }
        }
        finally {
            InlineStaticMockMaker.onMethodCallDuringVerification.remove();
        }
    }

    static void addSession(StaticMockitoSession session) {
        sessions.add(session);
    }

    static void removeSession(StaticMockitoSession session) {
        sessions.remove(session);
    }
}

