/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline;

import android.os.Build;
import android.os.Debug;
import com.android.dx.mockito.inline.IllegalClassFormatException;
import com.android.dx.mockito.inline.StaticClassTransformer;
import com.android.dx.mockito.inline.UnmodifiableClassException;
import dalvik.system.BaseDexClassLoader;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.ArrayList;

class StaticJvmtiAgent {
    private static final String AGENT_LIB_NAME = "libstaticjvmtiagent.so";
    private static final Object lock = new Object();
    private final ArrayList<StaticClassTransformer> transformers = new ArrayList();

    StaticJvmtiAgent() throws IOException {
        if (Build.VERSION.SDK_INT < 28) {
            throw new IOException("Requires API level 28. API level is " + Build.VERSION.SDK_INT);
        }
        ClassLoader cl = StaticJvmtiAgent.class.getClassLoader();
        if (!(cl instanceof BaseDexClassLoader)) {
            throw new IOException("Could not load jvmti plugin as StaticJvmtiAgent class was not loaded by a BaseDexClassLoader");
        }
        Debug.attachJvmtiAgent((String)AGENT_LIB_NAME, null, (ClassLoader)cl);
        this.nativeRegisterTransformerHook();
    }

    private native void nativeRegisterTransformerHook();

    private native void nativeUnregisterTransformerHook();

    protected void finalize() throws Throwable {
        this.nativeUnregisterTransformerHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestTransformClasses(Class<?>[] classes) throws UnmodifiableClassException {
        Object object = lock;
        synchronized (object) {
            try {
                this.nativeRetransformClasses(classes);
            }
            catch (RuntimeException e) {
                throw new UnmodifiableClassException(e);
            }
        }
    }

    public boolean shouldTransform(Class<?> classBeingRedefined) {
        for (StaticClassTransformer transformer : this.transformers) {
            if (!transformer.shouldTransform(classBeingRedefined)) continue;
            return true;
        }
        return false;
    }

    void addTransformer(StaticClassTransformer transformer) {
        this.transformers.add(transformer);
    }

    public byte[] runTransformers(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] transformedByteCode = classfileBuffer;
        for (StaticClassTransformer transformer : this.transformers) {
            transformedByteCode = transformer.transform(classBeingRedefined, transformedByteCode);
        }
        return transformedByteCode;
    }

    private native void nativeRetransformClasses(Class<?>[] var1);
}

