/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline;

import com.android.dx.mockito.inline.InlineStaticMockMaker;
import com.android.dx.mockito.inline.InvocationHandlerAdapter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class StaticMockMethodAdvice {
    private static final Pattern methodPattern = Pattern.compile("(.*)#(.*)\\((.*)\\)");
    private final Map<Object, InvocationHandlerAdapter> markersToHandler;
    private final Map<Class, Object> classToMarker;
    private final SelfCallInfo selfCallInfo = new SelfCallInfo();

    StaticMockMethodAdvice(Map<Object, InvocationHandlerAdapter> markerToHandler, Map<Class, Object> classToMarker) {
        this.markersToHandler = markerToHandler;
        this.classToMarker = classToMarker;
    }

    private static Object tryInvoke(Method origin, Object[] arguments) throws Throwable {
        try {
            return origin.invoke(null, arguments);
        }
        catch (InvocationTargetException exception) {
            throw exception.getCause();
        }
    }

    private static Class<?> classForTypeName(String name) throws ClassNotFoundException {
        if (name.endsWith("[]")) {
            return Class.forName("[L" + name.substring(0, name.length() - 2) + ";");
        }
        return Class.forName(name);
    }

    private static Class nameToType(String name) throws ClassNotFoundException {
        switch (name) {
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte[]": {
                return byte[].class;
            }
            case "short[]": {
                return short[].class;
            }
            case "int[]": {
                return int[].class;
            }
            case "long[]": {
                return long[].class;
            }
            case "char[]": {
                return char[].class;
            }
            case "float[]": {
                return float[].class;
            }
            case "double[]": {
                return double[].class;
            }
            case "boolean[]": {
                return boolean[].class;
            }
        }
        return StaticMockMethodAdvice.classForTypeName(name);
    }

    private static boolean isMethodDefinedBySuperClass(Class<?> subclass, Class<?> superClass, String methodName, Class<?>[] methodParameters) {
        while (subclass != superClass) {
            try {
                subclass.getDeclaredMethod(methodName, methodParameters);
                return false;
            }
            catch (NoSuchMethodException e) {
                if ((subclass = subclass.getSuperclass()) != null) continue;
                return false;
            }
            break;
        }
        return true;
    }

    private static List<Class<?>> getAllSubclasses(Class<?> superClass, Collection<Class> possibleSubClasses) {
        ArrayList subclasses = new ArrayList();
        for (Class possibleSubClass : possibleSubClasses) {
            if (!superClass.isAssignableFrom(possibleSubClass)) continue;
            subclasses.add(possibleSubClass);
        }
        return subclasses;
    }

    private static synchronized native String nativeGetCalledClassName(Thread var0);

    private Class<?> getClassMethodWasCalledOn(MethodDesc methodDesc) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> classDeclaringMethod = StaticMockMethodAdvice.classForTypeName(methodDesc.className);
        if (Modifier.isFinal(classDeclaringMethod.getModifiers()) || Modifier.isFinal(classDeclaringMethod.getDeclaredMethod(methodDesc.methodName, methodDesc.methodParamTypes).getModifiers())) {
            return classDeclaringMethod;
        }
        boolean mightBeMocked = false;
        for (Class<?> subClass : StaticMockMethodAdvice.getAllSubclasses(classDeclaringMethod, this.classToMarker.keySet())) {
            if (!StaticMockMethodAdvice.isMethodDefinedBySuperClass(subClass, classDeclaringMethod, methodDesc.methodName, methodDesc.methodParamTypes)) continue;
            mightBeMocked = true;
            break;
        }
        if (!mightBeMocked) {
            return null;
        }
        String calledClassName = StaticMockMethodAdvice.nativeGetCalledClassName(Thread.currentThread());
        return Class.forName(calledClassName);
    }

    public Method getOrigin(Object ignored, String methodWithTypeAndSignature) throws Throwable {
        MethodDesc methodDesc = new MethodDesc(methodWithTypeAndSignature);
        Class<?> clazz = this.getClassMethodWasCalledOn(methodDesc);
        if (clazz == null) {
            return null;
        }
        Object marker = this.classToMarker.get(clazz);
        if (!this.isMocked(marker)) {
            return null;
        }
        return Class.forName(methodDesc.className).getDeclaredMethod(methodDesc.methodName, methodDesc.methodParamTypes);
    }

    public Callable<?> handle(Object methodDescStr, Method origin, Object[] arguments) throws Throwable {
        BiConsumer<Class<?>, Method> onVerify;
        MethodDesc methodDesc = new MethodDesc((String)methodDescStr);
        Class<?> clazz = this.getClassMethodWasCalledOn(methodDesc);
        Object marker = this.classToMarker.get(clazz);
        InvocationHandlerAdapter interceptor = this.markersToHandler.get(marker);
        if (interceptor == null) {
            return null;
        }
        BiConsumer<Class<?>, Method> onStub = InlineStaticMockMaker.onMethodCallDuringStubbing.get();
        if (onStub != null) {
            onStub.accept(clazz, origin);
        }
        if ((onVerify = InlineStaticMockMaker.onMethodCallDuringVerification.get()) != null) {
            onVerify.accept(clazz, origin);
        }
        return new ReturnValueWrapper(interceptor.interceptEntryHook(marker, origin, arguments, (InvocationHandlerAdapter.SuperMethod)new SuperMethodCall(this.selfCallInfo, origin, marker, arguments)));
    }

    public boolean isMarker(Object marker) {
        return this.markersToHandler.containsKey(marker);
    }

    public boolean isMocked(Object marker) {
        return this.selfCallInfo.shouldMockMethod(marker) && this.isMarker(marker);
    }

    private static class SelfCallInfo
    extends ThreadLocal<Object> {
        private SelfCallInfo() {
        }

        boolean shouldMockMethod(Object value) {
            Object current = this.get();
            if (current == value) {
                this.set(null);
                return false;
            }
            return true;
        }
    }

    private static class MethodDesc {
        final String className;
        final String methodName;
        final Class<?>[] methodParamTypes;

        private MethodDesc(String methodWithTypeAndSignature) throws ClassNotFoundException {
            Matcher methodComponents = methodPattern.matcher(methodWithTypeAndSignature);
            boolean wasFound = methodComponents.find();
            if (!wasFound) {
                throw new IllegalArgumentException();
            }
            this.className = methodComponents.group(1);
            this.methodName = methodComponents.group(2);
            String[] methodParamTypeNames = methodComponents.group(3).split(",");
            ArrayList<Class> methodParamTypesList = new ArrayList<Class>(methodParamTypeNames.length);
            for (String methodParamName : methodParamTypeNames) {
                if (methodParamName.equals("")) continue;
                methodParamTypesList.add(StaticMockMethodAdvice.nameToType(methodParamName));
            }
            this.methodParamTypes = methodParamTypesList.toArray(new Class[0]);
        }

        public String toString() {
            return this.className + "#" + this.methodName;
        }
    }

    private static class ReturnValueWrapper
    implements Callable<Object> {
        private final Object returned;

        private ReturnValueWrapper(Object returned) {
            this.returned = returned;
        }

        @Override
        public Object call() {
            return this.returned;
        }
    }

    private static class SuperMethodCall
    implements InvocationHandlerAdapter.SuperMethod {
        private final SelfCallInfo selfCallInfo;
        private final Method origin;
        private final WeakReference<Object> marker;
        private final Object[] arguments;

        private SuperMethodCall(SelfCallInfo selfCallInfo, Method origin, Object marker, Object[] arguments) {
            this.selfCallInfo = selfCallInfo;
            this.origin = origin;
            this.marker = new WeakReference<Object>(marker);
            this.arguments = arguments;
        }

        public Object invoke() throws Throwable {
            if (!Modifier.isPublic(this.origin.getDeclaringClass().getModifiers() & this.origin.getModifiers())) {
                this.origin.setAccessible(true);
            }
            this.selfCallInfo.set(this.marker.get());
            return StaticMockMethodAdvice.tryInvoke(this.origin, this.arguments);
        }
    }
}

