/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline;

import android.os.Build;
import com.android.dx.mockito.inline.InlineDexmakerMockMaker;
import com.android.dx.mockito.inline.InvocationHandlerAdapter;
import com.android.dx.mockito.inline.MarkerToHandlerMap;
import com.android.dx.mockito.inline.MockFeatures;
import com.android.dx.mockito.inline.StaticClassTransformer;
import com.android.dx.mockito.inline.StaticJvmtiAgent;
import com.android.dx.mockito.inline.StaticMockMethodAdvice;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.mockito.Mockito;
import org.mockito.creation.instance.InstantiationException;
import org.mockito.creation.instance.Instantiator;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.InstantiatorProvider2;
import org.mockito.plugins.MockMaker;

public final class InlineStaticMockMaker
implements MockMaker {
    private static final StaticJvmtiAgent AGENT;
    private static final Throwable INITIALIZATION_ERROR;
    public static ThreadLocal<Class> mockingInProgressClass;
    public static ThreadLocal<BiConsumer<Class<?>, Method>> onMethodCallDuringStubbing;
    public static ThreadLocal<BiConsumer<Class<?>, Method>> onMethodCallDuringVerification;
    private final Map<Object, InvocationHandlerAdapter> markerToHandler = new MarkerToHandlerMap();
    private final Map<Class, Object> classToMarker = new HashMap<Class, Object>();
    private final StaticClassTransformer classTransformer;

    public InlineStaticMockMaker() {
        if (INITIALIZATION_ERROR != null) {
            throw new RuntimeException("Could not initialize inline mock maker.\n\nRelease: Android " + Build.VERSION.RELEASE + " " + Build.VERSION.INCREMENTAL + "Device: " + Build.BRAND + " " + Build.MODEL, INITIALIZATION_ERROR);
        }
        this.classTransformer = new StaticClassTransformer(AGENT, InlineDexmakerMockMaker.DISPATCHER_CLASS, this.markerToHandler, this.classToMarker);
    }

    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        Object mock;
        Class typeToMock = settings.getTypeToMock();
        if (!typeToMock.equals(mockingInProgressClass.get()) || Modifier.isAbstract(typeToMock.getModifiers())) {
            return null;
        }
        Set interfacesSet = settings.getExtraInterfaces();
        InvocationHandlerAdapter handlerAdapter = new InvocationHandlerAdapter(handler);
        this.classTransformer.mockClass(MockFeatures.withMockFeatures((Class)typeToMock, (Set)interfacesSet));
        Instantiator instantiator = ((InstantiatorProvider2)Mockito.framework().getPlugins().getDefaultPlugin(InstantiatorProvider2.class)).getInstantiator(settings);
        try {
            mock = instantiator.newInstance(typeToMock);
        }
        catch (InstantiationException e) {
            throw new MockitoException("Unable to create mock instance of type '" + typeToMock.getSimpleName() + "'", (Throwable)e);
        }
        if (this.classToMarker.containsKey(typeToMock)) {
            throw new MockitoException(typeToMock + " is already mocked");
        }
        this.classToMarker.put(typeToMock, mock);
        this.markerToHandler.put(mock, handlerAdapter);
        return (T)mock;
    }

    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        InvocationHandlerAdapter adapter = this.getInvocationHandlerAdapter(mock);
        if (adapter != null) {
            if (mockingInProgressClass.get() == mock.getClass()) {
                this.markerToHandler.remove(mock);
                this.classToMarker.remove(mock.getClass());
            } else {
                adapter.setHandler(newHandler);
            }
        }
    }

    public MockMaker.TypeMockability isTypeMockable(final Class<?> type) {
        if (mockingInProgressClass.get() == type) {
            return new MockMaker.TypeMockability(){

                public boolean mockable() {
                    return !Modifier.isAbstract(type.getModifiers()) && !type.isPrimitive() && type != String.class;
                }

                public String nonMockableReason() {
                    if (Modifier.isAbstract(type.getModifiers())) {
                        return "abstract type";
                    }
                    if (type.isPrimitive()) {
                        return "primitive type";
                    }
                    if (type == String.class) {
                        return "string";
                    }
                    return "not handled type";
                }
            };
        }
        return null;
    }

    public MockHandler getHandler(Object mock) {
        InvocationHandlerAdapter adapter = this.getInvocationHandlerAdapter(mock);
        return adapter != null ? adapter.getHandler() : null;
    }

    private InvocationHandlerAdapter getInvocationHandlerAdapter(Object marker) {
        if (marker == null) {
            return null;
        }
        return this.markerToHandler.get(marker);
    }

    static {
        StaticJvmtiAgent agent;
        mockingInProgressClass = new ThreadLocal();
        onMethodCallDuringStubbing = new ThreadLocal();
        onMethodCallDuringVerification = new ThreadLocal();
        Throwable initializationError = null;
        try {
            Method allowHiddenApiReflectionFrom;
            try {
                agent = new StaticJvmtiAgent();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Mockito could not self-attach a jvmti agent to the current VM. This feature is required for inline mocking.\nThis error occured due to an I/O error during the creation of this agent: " + ioe + "\n\nPotentially, the current VM does not support the jvmti API correctly", ioe);
            }
            try {
                Class<?> vmDebug = Class.forName("dalvik.system.VMDebug");
                allowHiddenApiReflectionFrom = vmDebug.getDeclaredMethod("allowHiddenApiReflectionFrom", Class.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new IllegalStateException("Cannot find VMDebug#allowHiddenApiReflectionFrom.");
            }
            try {
                allowHiddenApiReflectionFrom.invoke(null, StaticMockMethodAdvice.class);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable throwable) {
            agent = null;
            initializationError = throwable;
        }
        AGENT = agent;
        INITIALIZATION_ERROR = initializationError;
    }
}

