/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline.extended;

import com.android.dx.mockito.inline.InlineStaticMockMaker;
import com.android.dx.mockito.inline.extended.ExtendedMockito;
import com.android.dx.mockito.inline.extended.MockedMethod;
import com.android.dx.mockito.inline.extended.MockedVoidMethod;
import com.android.dx.mockito.inline.extended.UnstableApi;
import java.util.ArrayList;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;

@UnstableApi
public class StaticCapableStubber
implements Stubber {
    private Stubber instanceStubber;

    StaticCapableStubber(Stubber instanceStubber) {
        this.instanceStubber = instanceStubber;
    }

    public <T> T when(T mock) {
        return (T)this.instanceStubber.when(mock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void whenInt(MockedVoidMethod method) {
        if (InlineStaticMockMaker.onMethodCallDuringStubbing.get() != null) {
            throw new IllegalStateException("Stubbing is already in progress on this thread.");
        }
        ArrayList stubbingsSetUp = new ArrayList();
        InlineStaticMockMaker.onMethodCallDuringStubbing.set((clazz, stubbedMethod) -> {
            this.when(ExtendedMockito.staticMockMarker(clazz));
            stubbingsSetUp.add(stubbedMethod);
        });
        try {
            try {
                method.run();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            if (stubbingsSetUp.isEmpty()) {
                throw new IllegalArgumentException("Nothing was stubbed. Does the lambda call a static method on a 'static' mock/spy?");
            }
            if (stubbingsSetUp.size() > 1) {
                throw new IllegalArgumentException("Multiple intercepted calls on method " + stubbingsSetUp);
            }
        }
        finally {
            InlineStaticMockMaker.onMethodCallDuringStubbing.remove();
        }
    }

    @UnstableApi
    public void when(MockedVoidMethod method) {
        this.whenInt(method);
    }

    @UnstableApi
    public <T> void when(MockedMethod<T> method) {
        this.whenInt(method::get);
    }

    public StaticCapableStubber doThrow(Throwable ... toBeThrown) {
        this.instanceStubber = this.instanceStubber.doThrow(toBeThrown);
        return this;
    }

    public StaticCapableStubber doThrow(Class<? extends Throwable> toBeThrown) {
        this.instanceStubber = this.instanceStubber.doThrow(toBeThrown);
        return this;
    }

    @SafeVarargs
    public final StaticCapableStubber doThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... nextToBeThrown) {
        this.instanceStubber = this.instanceStubber.doThrow(toBeThrown, (Class[])nextToBeThrown);
        return this;
    }

    public StaticCapableStubber doAnswer(Answer answer) {
        this.instanceStubber = this.instanceStubber.doAnswer(answer);
        return this;
    }

    public StaticCapableStubber doNothing() {
        this.instanceStubber = this.instanceStubber.doNothing();
        return this;
    }

    public StaticCapableStubber doReturn(Object toBeReturned) {
        this.instanceStubber = this.instanceStubber.doReturn(toBeReturned);
        return this;
    }

    public StaticCapableStubber doReturn(Object toBeReturned, Object ... nextToBeReturned) {
        this.instanceStubber = this.instanceStubber.doReturn(toBeReturned, nextToBeReturned);
        return this;
    }

    public StaticCapableStubber doCallRealMethod() {
        this.instanceStubber = this.instanceStubber.doCallRealMethod();
        return this;
    }
}

