/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline.extended;

import com.android.dx.mockito.inline.InlineStaticMockMaker;
import com.android.dx.mockito.inline.extended.ExtendedMockito;
import com.android.dx.mockito.inline.extended.StaticMocking;
import com.android.dx.mockito.inline.extended.UnstableApi;
import java.util.ArrayList;
import java.util.HashMap;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.quality.Strictness;

@UnstableApi
public class StaticMockitoSession
implements MockitoSession {
    private static final HashMap<Class, Object> classToMarker = new HashMap();
    private final MockitoSession instanceSession;
    private final ArrayList<Class<?>> staticMocks = new ArrayList(0);

    StaticMockitoSession(MockitoSession instanceSession) {
        ExtendedMockito.addSession(this);
        this.instanceSession = instanceSession;
    }

    public void setStrictness(Strictness strictness) {
        this.instanceSession.setStrictness(strictness);
    }

    public void finishMocking() {
        this.finishMocking(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishMocking(Throwable failure) {
        try {
            this.instanceSession.finishMocking(failure);
        }
        catch (Throwable throwable) {
            for (Class<?> clazz : this.staticMocks) {
                InlineStaticMockMaker.mockingInProgressClass.set(clazz);
                try {
                    Mockito.reset((Object[])new Object[]{ExtendedMockito.staticMockMarker(clazz)});
                }
                finally {
                    InlineStaticMockMaker.mockingInProgressClass.remove();
                }
                classToMarker.remove(clazz);
            }
            ExtendedMockito.removeSession(this);
            throw throwable;
        }
        for (Class<?> clazz : this.staticMocks) {
            InlineStaticMockMaker.mockingInProgressClass.set(clazz);
            try {
                Mockito.reset((Object[])new Object[]{ExtendedMockito.staticMockMarker(clazz)});
            }
            finally {
                InlineStaticMockMaker.mockingInProgressClass.remove();
            }
            classToMarker.remove(clazz);
        }
        ExtendedMockito.removeSession(this);
    }

    <T> void mockStatic(StaticMocking<T> mocking) {
        if (ExtendedMockito.staticMockMarker(mocking.clazz) != null) {
            throw new IllegalArgumentException(mocking.clazz + " is already mocked");
        }
        InlineStaticMockMaker.mockingInProgressClass.set(mocking.clazz);
        try {
            classToMarker.put(mocking.clazz, mocking.markerSupplier.get());
        }
        finally {
            InlineStaticMockMaker.mockingInProgressClass.remove();
        }
        this.staticMocks.add(mocking.clazz);
    }

    <T> T staticMockMarker(Class<T> clazz) {
        return (T)classToMarker.get(clazz);
    }
}

