/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline.extended;

import com.android.dx.mockito.inline.extended.StaticMocking;
import com.android.dx.mockito.inline.extended.StaticMockitoSession;
import com.android.dx.mockito.inline.extended.UnstableApi;
import java.util.ArrayList;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.exceptions.misusing.UnfinishedMockingSessionException;
import org.mockito.quality.Strictness;
import org.mockito.session.MockitoSessionBuilder;
import org.mockito.session.MockitoSessionLogger;
import org.mockito.stubbing.Answer;

@UnstableApi
public class StaticMockitoSessionBuilder
implements MockitoSessionBuilder {
    private final ArrayList<StaticMocking> staticMockings = new ArrayList(0);
    private MockitoSessionBuilder instanceSessionBuilder;

    StaticMockitoSessionBuilder(MockitoSessionBuilder instanceSessionBuilder) {
        this.instanceSessionBuilder = instanceSessionBuilder;
    }

    @UnstableApi
    public <T> StaticMockitoSessionBuilder mockStatic(Class<T> clazz) {
        this.staticMockings.add(new StaticMocking<Object>(clazz, () -> Mockito.mock((Class)clazz)));
        return this;
    }

    @UnstableApi
    public <T> StaticMockitoSessionBuilder mockStatic(Class<T> clazz, Answer defaultAnswer) {
        this.staticMockings.add(new StaticMocking<Object>(clazz, () -> Mockito.mock((Class)clazz, (Answer)defaultAnswer)));
        return this;
    }

    @UnstableApi
    public <T> StaticMockitoSessionBuilder mockStatic(Class<T> clazz, MockSettings settings) {
        this.staticMockings.add(new StaticMocking<Object>(clazz, () -> Mockito.mock((Class)clazz, (MockSettings)settings)));
        return this;
    }

    @UnstableApi
    public <T> StaticMockitoSessionBuilder spyStatic(Class<T> clazz) {
        this.staticMockings.add(new StaticMocking<Object>(clazz, () -> Mockito.mock((Class)clazz, (MockSettings)Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS))));
        return this;
    }

    public StaticMockitoSessionBuilder initMocks(Object testClassInstance) {
        this.instanceSessionBuilder = this.instanceSessionBuilder.initMocks(testClassInstance);
        return this;
    }

    public StaticMockitoSessionBuilder initMocks(Object ... testClassInstances) {
        this.instanceSessionBuilder = this.instanceSessionBuilder.initMocks(testClassInstances);
        return this;
    }

    public StaticMockitoSessionBuilder name(String name) {
        this.instanceSessionBuilder = this.instanceSessionBuilder.name(name);
        return this;
    }

    public StaticMockitoSessionBuilder strictness(Strictness strictness) {
        this.instanceSessionBuilder = this.instanceSessionBuilder.strictness(strictness);
        return this;
    }

    public StaticMockitoSessionBuilder logger(MockitoSessionLogger logger) {
        this.instanceSessionBuilder = this.instanceSessionBuilder.logger(logger);
        return this;
    }

    public StaticMockitoSession startMocking() throws UnfinishedMockingSessionException {
        StaticMockitoSession session = new StaticMockitoSession(this.instanceSessionBuilder.startMocking());
        try {
            for (StaticMocking mocking : this.staticMockings) {
                session.mockStatic(mocking);
            }
        }
        catch (Throwable t) {
            try {
                session.finishMocking();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw t;
        }
        return session;
    }
}

