/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito;

import com.android.dx.mockito.InvocationHandlerAdapter;
import com.android.dx.mockito.UnsafeAllocator;
import com.android.dx.stock.ProxyBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.exceptions.stacktrace.StackTraceCleaner;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;
import org.mockito.plugins.StackTraceCleanerProvider;

public final class DexmakerMockMaker
implements MockMaker,
StackTraceCleanerProvider {
    private final UnsafeAllocator unsafeAllocator = UnsafeAllocator.create();
    private final boolean isApi28;

    public DexmakerMockMaker() {
        try {
            Class<?> buildVersion = Class.forName("android.os.Build$VERSION");
            this.isApi28 = buildVersion.getDeclaredField("SDK_INT").getInt(null) >= 28;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Cannot find android.os.Build$VERSION#SDK_INT. Field is needed to determine Android version.", e);
        }
        if (this.isApi28) {
            Method allowHiddenApiReflectionFromMethod;
            try {
                Class<?> vmDebug = Class.forName("dalvik.system.VMDebug");
                allowHiddenApiReflectionFromMethod = vmDebug.getDeclaredMethod("allowHiddenApiReflectionFrom", Class.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new IllegalStateException("Cannot find VMDebug#allowHiddenApiReflectionFrom. Method is needed to allow spies to copy blacklisted fields.");
            }
            try {
                allowHiddenApiReflectionFromMethod.invoke(null, LenientCopyTool.class);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                System.err.println("Cannot allow LenientCopyTool to copy spies of blacklisted fields. This might break spying on system classes.");
            }
            try {
                allowHiddenApiReflectionFromMethod.invoke(null, ProxyBuilder.class);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                System.err.println("Cannot allow ProxyBuilder to proxy blacklisted methods. This might break mocking on system classes.");
            }
        }
    }

    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        Class typeToMock = settings.getTypeToMock();
        Set interfacesSet = settings.getExtraInterfaces();
        Class[] extraInterfaces = interfacesSet.toArray(new Class[interfacesSet.size()]);
        InvocationHandlerAdapter invocationHandler = new InvocationHandlerAdapter(handler);
        if (typeToMock.isInterface()) {
            Class[] classesToMock = new Class[extraInterfaces.length + 1];
            classesToMock[0] = typeToMock;
            System.arraycopy(extraInterfaces, 0, classesToMock, 1, extraInterfaces.length);
            Object mock = Proxy.newProxyInstance(typeToMock.getClassLoader(), classesToMock, (InvocationHandler)invocationHandler);
            return (T)mock;
        }
        try {
            ProxyBuilder builder = ProxyBuilder.forClass((Class)typeToMock).implementing(extraInterfaces);
            if (this.isApi28) {
                builder.markTrusted();
            }
            Class proxyClass = builder.buildProxyClass();
            Object mock = this.unsafeAllocator.newInstance(proxyClass);
            ProxyBuilder.setInvocationHandler(mock, (InvocationHandler)invocationHandler);
            return mock;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MockitoException("Failed to mock " + typeToMock, (Throwable)e);
        }
    }

    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        InvocationHandlerAdapter adapter = this.getInvocationHandlerAdapter(mock);
        adapter.setHandler(newHandler);
    }

    public MockMaker.TypeMockability isTypeMockable(final Class<?> type) {
        return new MockMaker.TypeMockability(){

            public boolean mockable() {
                return !type.isPrimitive() && !Modifier.isFinal(type.getModifiers());
            }

            public String nonMockableReason() {
                if (type.isPrimitive()) {
                    return "primitive type";
                }
                if (Modifier.isFinal(type.getModifiers())) {
                    return "final or anonymous class";
                }
                return "not handled type";
            }
        };
    }

    public MockHandler getHandler(Object mock) {
        InvocationHandlerAdapter adapter = this.getInvocationHandlerAdapter(mock);
        return adapter != null ? adapter.getHandler() : null;
    }

    public StackTraceCleaner getStackTraceCleaner(final StackTraceCleaner defaultCleaner) {
        return new StackTraceCleaner(){

            public boolean isIn(StackTraceElement candidate) {
                String className = candidate.getClassName();
                return defaultCleaner.isIn(candidate) && !className.endsWith("_Proxy") && !className.startsWith("$Proxy") && !className.startsWith("java.lang.reflect.Proxy") && (!className.startsWith("com.android.dx.mockito.") || className.startsWith("com.android.dx.mockito.tests"));
            }
        };
    }

    private InvocationHandlerAdapter getInvocationHandlerAdapter(Object mock) {
        if (mock == null) {
            return null;
        }
        if (Proxy.isProxyClass(mock.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(mock);
            return invocationHandler instanceof InvocationHandlerAdapter ? (InvocationHandlerAdapter)invocationHandler : null;
        }
        if (ProxyBuilder.isProxyClass(mock.getClass())) {
            InvocationHandler invocationHandler = ProxyBuilder.getInvocationHandler((Object)mock);
            return invocationHandler instanceof InvocationHandlerAdapter ? (InvocationHandlerAdapter)invocationHandler : null;
        }
        return null;
    }
}

