/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dex.parser;

import com.linkedin.dex.parser.DexFileUtilsKt;
import com.linkedin.dex.parser.ParseUtils;
import com.linkedin.dex.parser.TestMethod;
import com.linkedin.dex.parser.TestMethodKt;
import com.linkedin.dex.spec.AnnotationsDirectoryItem;
import com.linkedin.dex.spec.ClassDefItem;
import com.linkedin.dex.spec.DexFile;
import com.linkedin.dex.spec.MethodIdItem;
import com.linkedin.dex.spec.TypeIdItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001aJ\u0010\u0003\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a \u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006*\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006*\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r\u001a\"\u0010\u0013\u001a\u00020\u0014*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"defaultDescriptors", "", "", "findJUnit3Tests", "Lcom/linkedin/dex/parser/TestMethod;", "dexFiles", "", "Lcom/linkedin/dex/spec/DexFile;", "Lkotlin/Pair;", "", "testNames", "descriptors", "findClassesWithSuperClass", "Lcom/linkedin/dex/spec/ClassDefItem;", "targetDescriptors", "findMethodIds", "", "Lcom/linkedin/dex/spec/MethodIdItem;", "classDefItem", "hasDirectSuperClass", "", "parser"})
public final class JUnit3ExtensionsKt {
    private static final Set<String> defaultDescriptors = SetsKt.setOf((Object[])new String[]{"Ljunit/framework/TestCase;", "Landroid/test/ActivityInstrumentationTestCase;", "Landroid/test/ActivityInstrumentationTestCase2;", "Landroid/test/ActivityTestCase;", "Landroid/test/ActivityUnitTestCase;", "Landroid/test/AndroidTestCase;", "Landroid/test/ApplicationTestCase;", "Landroid/test/FailedToCreateTests;", "Landroid/test/InstrumentationTestCase;", "Landroid/test/LoaderTestCase;", "Landroid/test/ProviderTestCase;", "Landroid/test/ProviderTestCase2;", "Landroid/test/ServiceTestCase;", "Landroid/test/SingleLaunchActivityTestCase;", "Landroid/test/SyncBaseInstrumentation;"});

    @NotNull
    public static final Set<TestMethod> findJUnit3Tests(@NotNull List<DexFile> dexFiles) {
        Intrinsics.checkNotNullParameter(dexFiles, (String)"dexFiles");
        boolean bl = false;
        return (Set)JUnit3ExtensionsKt.findJUnit3Tests(dexFiles, new LinkedHashSet(), CollectionsKt.toMutableSet((Iterable)defaultDescriptors)).getFirst();
    }

    private static final Pair<Set<TestMethod>, Set<String>> findJUnit3Tests(List<DexFile> dexFiles, Set<TestMethod> testNames, Set<String> descriptors) {
        if (dexFiles.isEmpty()) {
            return new Pair(testNames, descriptors);
        }
        Iterable $this$forEach$iv = dexFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DexFile dexFile = (DexFile)element$iv;
            boolean bl = false;
            List<TestMethod> newTestNames = JUnit3ExtensionsKt.findJUnit3Tests(dexFile, descriptors);
            testNames.addAll((Collection<TestMethod>)newTestNames);
        }
        return JUnit3ExtensionsKt.findJUnit3Tests(dexFiles.subList(0, CollectionsKt.getLastIndex(dexFiles)), testNames, descriptors);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TestMethod> findJUnit3Tests(DexFile $this$findJUnit3Tests, Set<String> descriptors) {
        void $this$filterTo$iv$iv;
        List<ClassDefItem> testClasses = JUnit3ExtensionsKt.findClassesWithSuperClass($this$findJUnit3Tests, descriptors);
        Iterable $this$filter$iv = TestMethodKt.createTestMethods($this$findJUnit3Tests, testClasses, (Function2<? super ClassDefItem, ? super AnnotationsDirectoryItem, ? extends List<MethodIdItem>>)((Function2)new Function2<ClassDefItem, AnnotationsDirectoryItem, List<? extends MethodIdItem>>($this$findJUnit3Tests){
            final /* synthetic */ DexFile $this_findJUnit3Tests;

            @NotNull
            public final List<MethodIdItem> invoke(@NotNull ClassDefItem classDef, @Nullable AnnotationsDirectoryItem $noName_1) {
                Intrinsics.checkNotNullParameter((Object)classDef, (String)"classDef");
                return JUnit3ExtensionsKt.findMethodIds(this.$this_findJUnit3Tests, classDef);
            }
            {
                this.$this_findJUnit3Tests = dexFile;
                super(2);
            }
        }));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestMethod it = (TestMethod)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)it.getTestName(), (CharSequence)"#test", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<MethodIdItem> findMethodIds(@NotNull DexFile $this$findMethodIds, @NotNull ClassDefItem classDefItem) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findMethodIds, (String)"$this$findMethodIds");
        Intrinsics.checkNotNullParameter((Object)classDefItem, (String)"classDefItem");
        Iterable $this$map$iv = DexFileUtilsKt.findMethodIdxs($this$findMethodIds, classDefItem);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MethodIdItem methodIdItem = $this$findMethodIds.getMethodIds()[it];
            collection.add(methodIdItem);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    private static final List<ClassDefItem> findClassesWithSuperClass(DexFile $this$findClassesWithSuperClass, Set<String> targetDescriptors) {
        boolean bl = false;
        List matchingClasses = new ArrayList();
        ClassDefItem[] $this$forEach$iv = $this$findClassesWithSuperClass.getClassDefs();
        boolean $i$f$forEach = false;
        ClassDefItem[] classDefItemArray = $this$forEach$iv;
        int n = classDefItemArray.length;
        for (int i = 0; i < n; ++i) {
            ClassDefItem element$iv;
            ClassDefItem classDefItem = element$iv = classDefItemArray[i];
            boolean bl2 = false;
            if (!JUnit3ExtensionsKt.hasDirectSuperClass($this$findClassesWithSuperClass, classDefItem, targetDescriptors)) continue;
            matchingClasses.add(classDefItem);
            targetDescriptors.add(ParseUtils.INSTANCE.parseDescriptor($this$findClassesWithSuperClass.getByteBuffer(), $this$findClassesWithSuperClass.getTypeIds()[classDefItem.getClassIdx()], $this$findClassesWithSuperClass.getStringIds()));
        }
        return matchingClasses;
    }

    private static final boolean hasDirectSuperClass(DexFile $this$hasDirectSuperClass, ClassDefItem classDefItem, Set<String> targetDescriptors) {
        if (classDefItem.getSuperclassIdx() == DexFile.Companion.getNO_INDEX()) {
            return false;
        }
        TypeIdItem superType = $this$hasDirectSuperClass.getTypeIds()[classDefItem.getSuperclassIdx()];
        String superDescriptor = ParseUtils.INSTANCE.parseDescriptor($this$hasDirectSuperClass.getByteBuffer(), superType, $this$hasDirectSuperClass.getStringIds());
        return targetDescriptors.contains(superDescriptor);
    }
}

