/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dex.parser;

import com.linkedin.dex.spec.ClassDefItem;
import com.linkedin.dex.spec.Leb128;
import com.linkedin.dex.spec.MethodIdItem;
import com.linkedin.dex.spec.StringIdItem;
import com.linkedin.dex.spec.TypeIdItem;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ7\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\u0002\u0010\u0013J)\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\u0002\u0010\u0016J)\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J)\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u001d\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/linkedin/dex/parser/ParseUtils;", "", "()V", "parseByteList", "", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "length", "", "parseClassName", "", "classDefItem", "Lcom/linkedin/dex/spec/ClassDefItem;", "typeIds", "", "Lcom/linkedin/dex/spec/TypeIdItem;", "stringIds", "Lcom/linkedin/dex/spec/StringIdItem;", "(Ljava/nio/ByteBuffer;Lcom/linkedin/dex/spec/ClassDefItem;[Lcom/linkedin/dex/spec/TypeIdItem;[Lcom/linkedin/dex/spec/StringIdItem;)Ljava/lang/String;", "parseDescriptor", "typeIdItem", "(Ljava/nio/ByteBuffer;Lcom/linkedin/dex/spec/TypeIdItem;[Lcom/linkedin/dex/spec/StringIdItem;)Ljava/lang/String;", "parseMethodName", "methodId", "Lcom/linkedin/dex/spec/MethodIdItem;", "(Ljava/nio/ByteBuffer;[Lcom/linkedin/dex/spec/StringIdItem;Lcom/linkedin/dex/spec/MethodIdItem;)Ljava/lang/String;", "parseStringBytes", "parseValueName", "nameIdx", "(Ljava/nio/ByteBuffer;[Lcom/linkedin/dex/spec/StringIdItem;I)Ljava/lang/String;", "parser"})
public final class ParseUtils {
    @NotNull
    public static final ParseUtils INSTANCE;

    @NotNull
    public final String parseClassName(@NotNull ByteBuffer byteBuffer, @NotNull ClassDefItem classDefItem, @NotNull TypeIdItem[] typeIds, @NotNull StringIdItem[] stringIds) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)classDefItem, (String)"classDefItem");
        Intrinsics.checkNotNullParameter((Object)typeIds, (String)"typeIds");
        Intrinsics.checkNotNullParameter((Object)stringIds, (String)"stringIds");
        TypeIdItem typeIdItem = typeIds[classDefItem.getClassIdx()];
        return this.parseDescriptor(byteBuffer, typeIdItem, stringIds);
    }

    @NotNull
    public final String parseDescriptor(@NotNull ByteBuffer byteBuffer, @NotNull TypeIdItem typeIdItem, @NotNull StringIdItem[] stringIds) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)typeIdItem, (String)"typeIdItem");
        Intrinsics.checkNotNullParameter((Object)stringIds, (String)"stringIds");
        int descriptorIdx = typeIdItem.getDescriptorIdx();
        StringIdItem descriptorId = stringIds[descriptorIdx];
        byteBuffer.position(descriptorId.getStringDataOff());
        Leb128.Companion.readUnsignedLeb128(byteBuffer);
        String encodedDescriptorName = this.parseStringBytes(byteBuffer);
        return encodedDescriptorName;
    }

    @NotNull
    public final String parseMethodName(@NotNull ByteBuffer byteBuffer, @NotNull StringIdItem[] stringIds, @NotNull MethodIdItem methodId) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)stringIds, (String)"stringIds");
        Intrinsics.checkNotNullParameter((Object)methodId, (String)"methodId");
        StringIdItem methodNameStringId = stringIds[methodId.getNameIdx()];
        byteBuffer.position(methodNameStringId.getStringDataOff());
        Leb128.Companion.readUnsignedLeb128(byteBuffer);
        String encodedName = this.parseStringBytes(byteBuffer);
        return encodedName;
    }

    @NotNull
    public final String parseValueName(@NotNull ByteBuffer byteBuffer, @NotNull StringIdItem[] stringIds, int nameIdx) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)stringIds, (String)"stringIds");
        StringIdItem stringId = stringIds[nameIdx];
        byteBuffer.position(stringId.getStringDataOff());
        Leb128.Companion.readUnsignedLeb128(byteBuffer);
        String encodedName = this.parseStringBytes(byteBuffer);
        return encodedName;
    }

    @NotNull
    public final String parseStringBytes(@NotNull ByteBuffer byteBuffer) {
        byte nextByte;
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        do {
            nextByte = byteBuffer.get();
            byteList.add(nextByte);
        } while (nextByte != (byte)0);
        byteList.remove(byteList.size() - 1);
        byte[] byArray = CollectionsKt.toByteArray((Collection)byteList);
        boolean bl = false;
        return new String(byArray, Charsets.UTF_8);
    }

    @NotNull
    public final List<Byte> parseByteList(@NotNull ByteBuffer byteBuffer, int length) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        byte[] tmpArray = new byte[length];
        byteBuffer.get(tmpArray, 0, length);
        return ArraysKt.toList((byte[])tmpArray);
    }

    private ParseUtils() {
    }

    static {
        ParseUtils parseUtils;
        INSTANCE = parseUtils = new ParseUtils();
    }
}

